# Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

# This file is part of Pandora, the Flexible Monitoring Platform.

# Pandora is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# Pandora is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with Pandora; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

# AC_PANDORA_COMPILER_OPTION(MESSAGE, VARIABLE-NAME, FLAGS,
#               [ACTION-SUCCESS], [ACTION-FAILURE])
# ----------------------------------------------------------------
# Check whether the given compiler option works
AC_DEFUN([AC_PANDORA_COMPILER_OPTION],
[AC_CACHE_CHECK([$1], [$2],
  [$2=no
   save_CXXFLAGS="$CXXFLAGS"
   CXXFLAGS="$CXXFLAGS $3"
   echo "$test_code" > conftest.$ac_ext
   rm -f conftest.$ac_objext
   if (eval $ac_compile 2>conftest.err) && test -s conftest.$ac_objext; then
    # The compiler can only warn and ignore the option if not recognized
    # So say no if there are warnings
    if test -s conftest.err; then
      # Append any errors to the config.log.
      cat conftest.err 1>&AS_MESSAGE_LOG_FD
    else
      $2=yes
    fi
   fi
   rm -f conftest*    
   CXXFLAGS="$save_CXXFLAGS"
])
 
if test x"[$]$2" = xyes; then
    ifelse([$4], , :, [$4])
else
    ifelse([$5], , :, [$5])
fi
])# AC_PANDORA_COMPILER_OPTION

# AC_PANDORA_COMPILER_OPTIONS(MESSAGE, VARIABLE-NAME, FLAGS,
#               [ACTION-SUCCESS], [ACTION-FAILURE])
# ----------------------------------------------------------------
# Check whether the given compiler option works
AC_DEFUN([AC_PANDORA_COMPILER_OPTIONS],
[AC_CACHE_CHECK([$1], [$2],
  [$2=none
   test_code="int some_variable = 0;" 
   save_CXXFLAGS="$CXXFLAGS"
   for flag in $3; do
    CXXFLAGS="$save_CXXFLAGS $flag"
    echo "$test_code" > conftest.$ac_ext
    rm -f conftest.$ac_objext
    if (eval $ac_compile 2>conftest.err) && test -s conftest.$ac_objext; then
     # The compiler can only warn and ignore the option if not recognized
     # So say no if there are warnings
     if test -s conftest.err; then
       # Append any errors to the config.log.
       cat conftest.err 1>&AS_MESSAGE_LOG_FD
     else
       $2=$flag
       break
     fi
    fi
    rm -f conftest*    
   done
   CXXFLAGS="$save_CXXFLAGS"
])
 
if test x"[$]$2" != xnone; then
    ifelse([$4], , :, [$4])
else
    $2=""
    ifelse([$5], , :, [$5])
fi
])# AC_PANDORA_COMPILER_OPTIONS

dnl
dnl	AC_PANDORA_CXX_INIT
dnl		(derived from tcpdump's AC_LBL_C_INIT)
dnl
AC_DEFUN(AC_PANDORA_CXX_INIT, [
  AC_PROG_CXX
  if test "$GXX" = yes; then
    CXXFLAGS=""
    if test "$ac_cv_prog_cxx_g" = yes ; then
    	DBGFLAGS="$DBGFLAGS -g"
	PROFFLAGS="$PROFFLAGS -pg"
  	AC_PANDORA_COMPILER_OPTIONS([how to disable weak symbols with $CXX], 
		noweak_flag, [-fno-weak], DBGFLAGS="$DBGFLAGS $noweak_flag")
	
    fi
    if test "$enable_debug" = no; then
    	OPTFLAGS="$OPTFLAGS -O3"
    else
    	OPTFLAGS="$OPTFLAGS -O2"
    	DBGFLAGS="$DBGFLAGS -Wall -Wno-unused"
    	DBGFLAGS="$DBGFLAGS -Wmissing-prototypes"
    	DBGFLAGS="$DBGFLAGS -Wstrict-prototypes"
    fi
    AC_PANDORA_COMPILER_OPTION([if $CXX supports -pipe], pipe_ok, [-pipe],
			       CXXFLAGS="$CXXFLAGS -pipe")
  else
    case "$build_os" in 
      osf*)	DBGFLAGS="-g3"
		OPTFLAGS="-O4"
		PROFFLAGS="-pg"
		CXXFLAGS="-std ansi -ptr /var/tmp/pandora-cxx_repository" 
		LD="$CXX -ptr /var/tmp/pandora-cxx_repository";;
      *)	;;
    esac
  fi  
  AC_PANDORA_COMPILER_OPTIONS([how to disable rtti with $CXX], nortti_flag,
				[-fno-rtti -nortti -feature=no%rtti],
				CXXFLAGS="$CXXFLAGS $nortti_flag")
  AC_PANDORA_COMPILER_OPTIONS([how to disable exceptions with $CXX], noex_flag,
				[-fno-exceptions -noexceptions -noex],
				CXXFLAGS="$CXXFLAGS $noex_flag")
])

dnl
dnl Check endedness, without autoconf warning
dnl
dnl AC_PANDORA_C_BIGENDIAN
dnl
AC_DEFUN(AC_PANDORA_C_BIGENDIAN,
[AC_CACHE_CHECK(whether byte ordering is bigendian, ac_cv_c_bigendian,
[ac_cv_c_bigendian=unknown
# See if sys/param.h defines the BYTE_ORDER macro.
AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/param.h>], [
#if !BYTE_ORDER || !BIG_ENDIAN || !LITTLE_ENDIAN
 bogus endian macros
#endif], [# It does; now see whether it defined to BIG_ENDIAN or not.
AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/param.h>], [
#if BYTE_ORDER != BIG_ENDIAN
 not big endian
#endif], ac_cv_c_bigendian=yes, ac_cv_c_bigendian=no)])
if test $ac_cv_c_bigendian = unknown; then
AC_TRY_RUN([main () {
  /* Are we little or big endian?  From Harbison&Steele.  */
  union
  {
    long l;
    char c[sizeof (long)];
  } u;
  u.l = 1;
  exit (u.c[sizeof (long) - 1] == 1);
}], ac_cv_c_bigendian=no, ac_cv_c_bigendian=yes, ac_cv_c_bigendian=unknown)
fi])
if test $ac_cv_c_bigendian = yes; then
  AC_DEFINE([WORDS_BIGENDIAN], 1, [Define to 1 if the architecture use bigendian words])
fi
])

dnl
dnl	AC_PANDORA_CHECK_TYPE
dnl		(derived from tcpdump's AC_LBL_CHECK_TYPE)
dnl
AC_DEFUN(AC_PANDORA_CHECK_TYPE,
    [AC_MSG_CHECKING(for $1 using $CC)
    AC_CACHE_VAL(ac_cv_pandora_have_$1,
	AC_TRY_COMPILE([
#include "confdefs.h"
#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif
#ifdef HAVE_SYS_BITYPES_H
#include <sys/bitypes.h>
#endif
],
	[$1 i],
	ac_cv_pandora_have_$1=yes,
	ac_cv_pandora_have_$1=no))
    AC_MSG_RESULT($ac_cv_pandora_have_$1)
    if test $ac_cv_pandora_have_$1 = no ; then
	    AC_DEFINE([$1], $2, [])
    fi])

dnl
dnl	AC_PANDORA_CHECK_TYPE_IN_HDR
dnl
AC_DEFUN(AC_PANDORA_CHECK_TYPE_IN_HDR,
    [AC_MSG_CHECKING(for $1 in $3 using $CC)
    AC_CACHE_VAL(ac_cv_pandora_have_$1,
	AC_TRY_COMPILE([
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif
#include <$3>
],
	[$1 i],
	ac_cv_pandora_have_$1=yes,
	ac_cv_pandora_have_$1=no))
    AC_MSG_RESULT($ac_cv_pandora_have_$1)
    if test $ac_cv_pandora_have_$1 = no ; then
	    AC_DEFINE([$1], $2, [])
    fi])

dnl
dnl AC_PANDORA_SIZEOF
dnl
AC_DEFUN([AC_PANDORA_SIZEOF], [
	AC_CHECK_SIZEOF(char)
	AC_CHECK_SIZEOF(short)
	AC_CHECK_SIZEOF(int)
	AC_CHECK_SIZEOF(long)
	AC_CHECK_SIZEOF(long long)
])

dnl
dnl AC_STRUCT_IP
dnl
AC_DEFUN(AC_STRUCT_IP, [
	AC_MSG_CHECKING([struct ip])
	AC_TRY_COMPILE([#include <sys/types.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>],
               [struct ip ip;],
               [AC_MSG_RESULT(yes); bsd_networking=yes],
               [AC_MSG_RESULT(no); bsd_networking=no]);
	if test $bsd_networking = yes; then
		AC_DEFINE([BSD_NETWORKING], 1, [Define to 1 if we must use BSDish networking])
		AC_MSG_CHECKING([ip_v in struct ip])
		AC_TRY_COMPILE([#include <sys/types.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>],
			[struct ip ip; ip.ip_v;],
			[AC_MSG_RESULT(yes); has_bitfields=yes],
			[AC_MSG_RESULT(no); has_bitfields=no])
		if test $has_bitfields = no; then
			SAVE_CXXFLAGS="$CXXFLAGS"
			CXXFLAGS="-D__STDC__=2"
			AC_MSG_CHECKING([if setting __STDC__=2 gives ip_v])
			AC_TRY_COMPILE([#include <sys/types.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>],
			[struct ip ip; ip.ip_v;],
				[AC_MSG_RESULT(yes); setting_stdc_helps=yes],
				[AC_MSG_RESULT(no); setting_stdc_helps=no])
	
			CXXFLAGS="$SAVE_CXXFLAGS"
			if test $setting_stdc_helps = yes; then
				CXXFLAGS="$CXXFLAGS -D__STDC__=2"
			else
				AC_MSG_ERROR(Can't figure out how to get bitfields - configure failed)
			fi
		fi
	fi])

dnl
dnl AC_PANDORA_TYPE_SIGNAL
dnl 	(derived from tcpdump's AC_LBL_TYPE_SIGNAL)
dnl
AC_DEFUN(AC_PANDORA_TYPE_SIGNAL,
    [AC_TYPE_SIGNAL
    if test "$ac_cv_type_signal" = void ; then
	    AC_DEFINE([RETSIGVAL], , [Define to the value to be returned from a signal handler])
    else
	    AC_DEFINE([RETSIGVAL], 0, [Define to the value to be returned from a signal handler])
    fi
    case "$build_os" in

    irix*)
	    AC_DEFINE([_BSD_SIGNALS], 1, [Define if you want to use BSDish signals])
	    ;;

    *)
	    dnl prefer sigset() to sigaction()
	    AC_CHECK_FUNCS(sigset)
	    if test $ac_cv_func_sigset = no ; then
		    AC_CHECK_FUNCS(sigaction)
	    fi
	    ;;
    esac])

dnl
dnl AC_PANDORA_PTHREAD
dnl
AC_DEFUN(AC_PANDORA_PTHREAD, [
	dnl Check for libexc for OSF/1
	AC_CHECK_LIB(exc, exc_continue)
	AC_CHECK_LIB(pthread, pthread_exit)
	if test $ac_cv_lib_pthread_pthread_exit = no; then
		SAVE_CXXFLAGS="$CXXFLAGS"
		AC_CACHE_CHECK([whether -pthread gives POSIX threads], 
				ac_cv_pthread_switch,
		CXXFLAGS="-pthread"
	  	AC_TRY_COMPILE([#include <pthread.h>],
				[pthread_exit(NULL);],
				ac_cv_pthread_switch="yes", 
				ac_cv_pthread_switch="no"))
		CXXFLAGS="$SAVE_CXXFLAGS"
		if test "$ac_cv_pthread_switch" = "yes"; then
			CXXFLAGS="$CXXFLAGS -pthread"
		else
			AC_MSG_ERROR("you need POSIX threads.")
		fi
	fi
	CFLAGS="$CFLAGS -D_REENTRANT "	
	CXXFLAGS="$CXXFLAGS -D_REENTRANT "])

dnl
dnl	AC_PANDORA_FUNC_INET_ATON
dnl
AC_DEFUN(AC_PANDORA_FUNC_INET_ATON, [
	AC_CACHE_CHECK([for inet_aton], ac_cv_pandora_inet_aton,
		AC_TRY_COMPILE([#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
			], [char src[128];
			struct in_addr dst;
			inet_aton(src, &dst);],
			ac_cv_pandora_inet_aton=yes, 
			ac_cv_pandora_inet_aton=no))
	if test "$ac_cv_pandora_inet_aton" = "no"; then
		AC_REPLACE_FUNCS(inet_aton)
	fi])


dnl @synopsis ACX_PTHREAD([ACTION-IF-FOUND[, ACTION-IF-NOT-FOUND]])
dnl
dnl This macro figures out how to build C programs using POSIX
dnl threads.  It sets the PTHREAD_LIBS output variable to the threads
dnl library and linker flags, and the PTHREAD_CFLAGS output variable
dnl to any special C compiler flags that are needed.  (The user can also
dnl force certain compiler flags/libs to be tested by setting these
dnl environment variables.)
dnl
dnl Also sets PTHREAD_CC to any special C compiler that is needed for
dnl multi-threaded programs (defaults to the value of CC otherwise).
dnl (This is necessary on AIX to use the special cc_r compiler alias.)
dnl
dnl If you are only building threads programs, you may wish to
dnl use these variables in your default LIBS, CXXFLAGS, and CXX:
dnl
dnl        LIBS="$PTHREAD_LIBS $LIBS"
dnl        CXXFLAGS="$CXXFLAGS $PTHREAD_CXXFLAGS"
dnl        CXX="$PTHREAD_CXX"
dnl
dnl In addition, if the PTHREAD_CREATE_JOINABLE thread-attribute
dnl constant has a nonstandard name, defines PTHREAD_CREATE_JOINABLE
dnl to that name (e.g. PTHREAD_CREATE_UNDETACHED on AIX).
dnl
dnl ACTION-IF-FOUND is a list of shell commands to run if a threads
dnl library is found, and ACTION-IF-NOT-FOUND is a list of commands
dnl to run it if it is not found.  If ACTION-IF-FOUND is not specified,
dnl the default action will define HAVE_PTHREAD.
dnl
dnl Please let the authors know if this macro fails on any platform,
dnl or if you have any other suggestions or comments.  This macro was
dnl based on work by SGJ on autoconf scripts for FFTW (www.fftw.org)
dnl (with help from M. Frigo), as well as ac_pthread and hb_pthread
dnl macros posted by AFC to the autoconf macro repository.  We are also
dnl grateful for the helpful feedback of numerous users.
dnl
dnl @version $Id: acinclude.m4,v 1.36 2002/10/24 13:37:25 patarin Exp $
dnl @author Steven G. Johnson <stevenj@alum.mit.edu> and Alejandro Forero Cuervo <bachue@bachue.com>

AC_DEFUN([ACX_PTHREAD], [
AC_REQUIRE([AC_CANONICAL_HOST])
acx_pthread_ok=no

# First, check if the POSIX threads header, pthread.h, is available.
# If it isn't, don't bother looking for the threads libraries.
AC_CHECK_HEADER(pthread.h, , acx_pthread_ok=noheader)

# We must check for the threads library under a number of different
# names; the ordering is very important because some systems
# (e.g. DEC) have both -lpthread and -lpthreads, where one of the
# libraries is broken (non-POSIX).

# First of all, check if the user has set any of the PTHREAD_LIBS,
# etcetera environment variables, and if threads linking works using
# them:
if test x"$PTHREAD_LIBS$PTHREAD_CXXFLAGS" != x; then
        save_CXXFLAGS="$CXXFLAGS"
        CXXFLAGS="$CXXFLAGS $PTHREAD_CXXFLAGS"
        save_LIBS="$LIBS"
        LIBS="$PTHREAD_LIBS $LIBS"
        AC_MSG_CHECKING([for pthread_join in LIBS=$PTHREAD_LIBS with CXXFLAGS=$PTHREAD_CXXFLAGS])
        AC_TRY_LINK_FUNC(pthread_join, acx_pthread_ok=yes)
        AC_MSG_RESULT($acx_pthread_ok)
        if test x"$acx_pthread_ok" = xno; then
                PTHREAD_LIBS=""
                PTHREAD_CXXFLAGS=""
        fi
        LIBS="$save_LIBS"
        CXXFLAGS="$save_CXXFLAGS"
fi

# Create a list of thread flags to try.  Items starting with a "-" are
# C compiler flags, and other items are library names, except for "none"
# which indicates that we try without any flags at all.

acx_pthread_flags="pthreads none -Kthread -kthread lthread -pthread -pthreads -mthreads -mt pthread --thread-safe"

# The ordering *is* (sometimes) important.  Some notes on the
# individual items follow:

# pthreads: AIX (must check this before -lpthread)
# none: in case threads are in libc; should be tried before -Kthread and
#       other compiler flags to prevent continual compiler warnings
# -Kthread: Sequent (threads in libc, but -Kthread needed for pthread.h)
# -kthread: FreeBSD kernel threads (preferred to -pthread since SMP-able)
# lthread: LinuxThreads port on FreeBSD (also preferred to -pthread)
# -pthread: Linux/gcc (kernel threads), BSD/gcc (userland threads)
# -pthreads: Solaris/gcc
# -mthreads: Mingw32/gcc, Lynx/gcc
# -mt: Sun Workshop C (may only link SunOS threads, but doesn't hurt to check)
# pthread: Linux, etcetera
# --thread-safe: KAI C++

case "${build_cpu}-${build_os}" in
        *solaris*)

        # On Solaris (at least, for some versions), libc contains stubbed
        # (non-functional) versions of the pthreads routines, so link-based
        # tests will erroneously succeed.  (We need to link with -pthread or
        # -lpthread.)  (The stubs are missing pthread_cleanup_push, or rather
        # a function called by this macro, so we could check for that, but
        # who knows whether they'll stub that too in a future libc.)  So,
        # we'll just look for -pthreads and -lpthread first:

        acx_pthread_flags="-pthread -pthreads -mt pthread $acx_pthread_flags"
        ;;
esac

if test x"$acx_pthread_ok" = xno; then
for flag in $acx_pthread_flags; do

        case $flag in
                none)
                AC_MSG_CHECKING([whether pthreads work without any flags])
                ;;

                -*)
                AC_MSG_CHECKING([whether pthreads work with $flag])
                PTHREAD_CXXFLAGS="$flag"
                ;;

                *)
                AC_MSG_CHECKING([for the pthreads library -l$flag])
                PTHREAD_LIBS="-l$flag"
                ;;
        esac

        save_LIBS="$LIBS"
        save_CXXFLAGS="$CXXFLAGS"
        LIBS="$PTHREAD_LIBS $LIBS"
        CXXFLAGS="$CXXFLAGS $PTHREAD_CXXFLAGS"

        # Check for various functions.  We must include pthread.h,
        # since some functions may be macros.  (On the Sequent, we
        # need a special flag -Kthread to make this header compile.)
        # We check for pthread_join because it is in -lpthread on IRIX
        # while pthread_create is in libc.  We check for pthread_attr_init
        # due to DEC craziness with -lpthreads.  We check for
        # pthread_cleanup_push because it is one of the few pthread
        # functions on Solaris that doesn't have a non-functional libc stub.
        # We try pthread_create on general principles.
        AC_TRY_LINK([#include <pthread.h>],
                    [	pthread_t th; 
			pthread_join(th, 0);
                     	pthread_attr_init(0); 
			pthread_cleanup_push(0, 0);
                     	pthread_create(0,0,0,0); 
			pthread_cleanup_pop(0); ],
                    [acx_pthread_ok=yes])

        LIBS="$save_LIBS"
        CXXFLAGS="$save_CXXFLAGS"

        AC_MSG_RESULT($acx_pthread_ok)
        if test "x$acx_pthread_ok" = xyes; then
                break;
        fi

        PTHREAD_LIBS=""
        PTHREAD_CXXFLAGS=""
done
fi

# Various other checks:
if test "x$acx_pthread_ok" = xyes; then
        save_LIBS="$LIBS"
        LIBS="$PTHREAD_LIBS $LIBS"
        save_CXXFLAGS="$CXXFLAGS"
        CXXFLAGS="$CXXFLAGS $PTHREAD_CXXFLAGS"

        # Detect AIX lossage: threads are created detached by default
        # and the JOINABLE attribute has a nonstandard name (UNDETACHED).
        AC_MSG_CHECKING([for joinable pthread attribute])
        AC_TRY_LINK([#include <pthread.h>],
                    [int attr=PTHREAD_CREATE_JOINABLE;],
                    ok=PTHREAD_CREATE_JOINABLE, ok=unknown)
        if test x"$ok" = xunknown; then
                AC_TRY_LINK([#include <pthread.h>],
                            [int attr=PTHREAD_CREATE_UNDETACHED;],
                            ok=PTHREAD_CREATE_UNDETACHED, ok=unknown)
        fi
        if test x"$ok" != xPTHREAD_CREATE_JOINABLE; then
                AC_DEFINE([PTHREAD_CREATE_JOINABLE], $ok,
                          [Define to the necessary symbol if this constant
                           uses a non-standard name on your system.])
        fi
        AC_MSG_RESULT(${ok})
        if test x"$ok" = xunknown; then
                AC_MSG_WARN([we do not know how to create joinable pthreads])
        fi

        AC_MSG_CHECKING([if more special flags are required for pthreads])
        flag=no
        case "${build_cpu}-${build_os}" in
                *-aix* | *-freebsd*)     		flag="-D_THREAD_SAFE";;
                *solaris* | alpha*-osf* | *-linux*) 	flag="-D_REENTRANT";;
        esac
        AC_MSG_RESULT(${flag})
        if test "x$flag" != xno; then
                PTHREAD_CXXFLAGS="$flag $PTHREAD_CXXFLAGS"
        fi

        LIBS="$save_LIBS"
        CXXFLAGS="$save_CXXFLAGS"

        # More AIX lossage: must compile with cc_r
        AC_CHECK_PROG(PTHREAD_CXX, cc_r, cc_r, ${CXX})
else
        PTHREAD_CXX="$CXX"
fi

AC_SUBST(PTHREAD_LIBS)
AC_SUBST(PTHREAD_CXXFLAGS)
AC_SUBST(PTHREAD_CXX)

# Finally, execute ACTION-IF-FOUND/ACTION-IF-NOT-FOUND:
if test x"$acx_pthread_ok" = xyes; then
        ifelse([$1],,AC_DEFINE([HAVE_PTHREAD],1,[Define if you have POSIX threads libraries and header files.]),[$1])
        :
else
        acx_pthread_ok=no
        $2
fi
])dnl ACX_PTHREAD

dnl ***********************************
dnl * Checks for PCRE
dnl ***********************************
AC_DEFUN([AC_PANDORA_PCRE], [
	pcre_ok=yes

	AC_CHECK_HEADERS(pcre.h, , pcre_ok=noheader)

	if test x$pcre_ok = xyes; then
		AC_CHECK_LIB(pcre, pcre_exec, LIBPCRE="-lpcre", pcre_ok=no)
	fi

	AM_CONDITIONAL(build_pcre, test x$pcre_ok = xyes)
])dnl AC_PANDORA_PCRE

dnl ***********************************
dnl * Checks for SSL
dnl ***********************************
AC_DEFUN([AC_PANDORA_SSL], [
	ssl_ok=yes

	AC_CHECK_HEADERS(openssl/ssl.h, , ssl_ok=noheader)

	if test x$ssl_ok = xyes; then
		AC_CHECK_LIB(ssl, SSL_read, LIBSSL="-lssl", ssl_ok=no)
	fi

	AM_CONDITIONAL(build_ssl, test x$ssl_ok = xyes)
	if test "x$ssl_ok" = xyes; then
		AC_DEFINE([USE_SSL], 1, [Define to 1 if you have OpenSSL installed])
	fi
])dnl AC_PANDORA_SSL

dnl ***********************************
dnl * Checks for FAM
dnl ***********************************
AC_DEFUN([AC_PANDORA_FAM], [
	fam_ok=yes

	AC_CHECK_HEADERS(fam.h, , fam_ok=noheader)

	if test x$fam_ok = xyes; then
		AC_CHECK_LIB(fam, FAMOpen, LIBFAM="-lfam", fam_ok=no)
	fi

	AM_CONDITIONAL(build_fam, test x$fam_ok = xyes)
])dnl AC_PANDORA_FAM

dnl ***********************************
dnl * Checks for SNMP
dnl ***********************************
AC_DEFUN([AC_PANDORA_SNMP], [
	snmp_ok=yes

	AC_CHECK_HEADERS(ucd-snmp/snmp.h, , snmp_ok=noheader, [
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif
#define oid int
])

	LIBS_SAVE="$LIBS"
	if test x$snmp_ok = xyes; then
		AC_CHECK_LIB(crypto, des_ncbc_encrypt,,)
		AC_CHECK_LIB(snmp, snmp_open,,)
		if test $ac_cv_lib_snmp_snmp_open = yes; then
			LIBSNMP=$LIBS
			AC_MSG_CHECKING([whether we need sbuf])
			AC_EGREP_CPP([sbuf],[#include <ucd-snmp/mib.h>],
				[use_sbuf=yes], [use_sbuf=no])
			if test $use_sbuf = "yes" ; then
				AC_DEFINE([USE_SBUF], 1, [Define to 1 if we need to use sbufs in UCD-SNMP])
			fi
			AC_MSG_RESULT($use_sbuf)
		else
			snmp_ok=no
		fi 
	fi

	LIBS="$LIBS_SAVE"

	AM_CONDITIONAL(build_snmp, test x$snmp_ok = xyes)
])dnl AC_PANDORA_SNMP

dnl ***********************************
dnl * Checks for RRD
dnl ***********************************
AC_DEFUN([AC_PANDORA_RRD], [
	rrd_ok=yes

	AC_CHECK_HEADERS(rrd.h, , rrd_ok=noheader)

	LIBS_SAVE="$LIBS"
	if test x$rrd_ok = xyes; then
		AC_CHECK_LIB(rrd, rrd_create,,)
		if test $ac_cv_lib_rrd_rrd_create = yes; then
			LIBRRD=$LIBS
		else
			rrd_ok=no
		fi 
	fi

	LIBS="$LIBS_SAVE"

	AM_CONDITIONAL(build_rrd, test x$rrd_ok = xyes)
])dnl AC_PANDORA_RRD

dnl ***********************************
dnl * Checks for Guile
dnl ***********************************
AC_DEFUN([AC_PANDORA_GUILE], [
	guile_ok=yes

	AC_CHECK_HEADERS(libguile.h guile/gh.h, , 
			 guile_ok=noheader && break)

	LIBS_SAVE="$LIBS"
	if test x$guile_ok = xyes; then
		LIBS=""
		AC_CHECK_LIB(m, cos,,)
		AC_CHECK_LIB(qthreads, qt_abort,,)
		AC_CHECK_LIB(guile, scm_ntohl,,)
		if test $ac_cv_lib_guile_scm_ntohl = yes; then
			LIBGUILE=$LIBS
		else
			guile_ok=no
		fi 
	fi

	if test x$guile_ok != xyes; then
		AC_MSG_WARN([guile 1.4 not properly installed (headers/library)])
	fi
	LIBS="$LIBS_SAVE"

	AM_CONDITIONAL(build_guile, test x$guile_ok = xyes)
])dnl AC_PANDORA_GUILE

dnl
dnl Checks to see if unaligned memory accesses fail
dnl
dnl usage:
dnl
dnl	AC_LBL_UNALIGNED_ACCESS
dnl
dnl results:
dnl
dnl	LBL_ALIGN (DEFINED)
dnl
AC_DEFUN(AC_LBL_UNALIGNED_ACCESS,
    [AC_MSG_CHECKING(if unaligned accesses fail)
    AC_CACHE_VAL(ac_cv_lbl_unaligned_fail,
	[case "$build_cpu" in

	alpha*|hp*|mips*|sparc*)
		ac_cv_lbl_unaligned_fail=yes
		;;

	*)
		cat >conftest.c <<EOF
#		include <sys/types.h>
#		include <sys/wait.h>
#		include <stdio.h>
		unsigned char a[[5]] = { 1, 2, 3, 4, 5 };
		main() {
		unsigned int i;
		pid_t pid;
		int status;
		/* avoid "core dumped" message */
		pid = fork();
		if (pid <  0)
			exit(2);
		if (pid > 0) {
			/* parent */
			pid = waitpid(pid, &status, 0);
			if (pid < 0)
				exit(3);
			exit(!WIFEXITED(status));
		}
		/* child */
		i = *(unsigned int *)&a[[1]];
		printf("%d\n", i);
		exit(0);
		}
EOF
		${CC-cc} -o conftest $CFLAGS $CPPFLAGS $LDFLAGS \
		    conftest.c $LIBS >/dev/null 2>&1
		if test ! -x conftest ; then
			dnl failed to compile for some reason
			ac_cv_lbl_unaligned_fail=yes
		else
			./conftest >conftest.out
			if test ! -s conftest.out ; then
				ac_cv_lbl_unaligned_fail=yes
			else
				ac_cv_lbl_unaligned_fail=no
			fi
		fi
		rm -f conftest* core core.conftest
		;;
	esac])
    AC_MSG_RESULT($ac_cv_lbl_unaligned_fail)
    if test $ac_cv_lbl_unaligned_fail = yes ; then
	    AC_DEFINE([LBL_ALIGN], 1, [Define to 1 if unaligned access fails])
    fi])
