/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include <libpandora/clock.h>
#include <libpandora/timeval.h>

Clock *wallclock = NULL;

Clock::Clock(int r)
  : res(r)
{
  if (wallclock != NULL) {
    pandora_error("only one instance of Clock may exist");
  } else {
    wallclock = this;
  }
  if (gettimeofday(&current, NULL) < 0) {
    current.tv_sec = 0;
    current.tv_usec = 0;
    pandora_pwarning("gettimeofday");
  }
}

Clock::~Clock(void)
{
  if (isRunning()) {
    current.tv_sec = 0;
    cancel();
    join();
    //pandora_debug("clock joined");
  }
  current.tv_sec = 0;
  current.tv_usec = 0;
  wallclock = NULL;
}

void Clock::main(void)
{
  if (current.tv_sec == 0) {
    pandora_warning("cannot start Clock thread");
    return;
  }

  timeval target = current;
  while (1) {
    //pandora_debug("current time: " << current);
    target = target + res;
    int stime = diffTimeStamp(target, current);
    if (stime > 0) usleep(stime * 1000);
    if (current.tv_sec == 0) break;
    if (gettimeofday(&current, NULL) < 0) {
      pandora_pwarning("gettimeofday");
      break;
    }
  }
}
