/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef COMP_CACHE_H
#define COMP_CACHE_H

#include <libpandora/global.h>

#include <libpandora/queue.h>
#include <libpandora/thread.h>

class Component;
class CompEntry;

class CompCache {
private:
  typedef Queue<Component *> CompQueue;

private:
  static int default_capacity;
  CompQueue *cache;
  int size, capacity;
  bool flushAll;
  //Mutex mx;

public:
  CompCache(int siz, int cap = default_capacity) : cache(NULL),
    size(siz), capacity(cap), flushAll(false) {
    __DELETE_ARRAY(cache);
    cache = new CompQueue[siz];
  }

  ~CompCache(void) {
    flush();
    __DELETE_ARRAY(cache);
  }

  Component *get(int, const CompEntry *);
  void release(Component *);
  void setFlushAll(void) {flushAll = true; }
  void flush(void);

  static inline void setDefaultCapacity(int cap);
  static inline int  getDefaultCapacity(void);
};

void CompCache::setDefaultCapacity(int cap) 
{ 
  if (cap >= 0) default_capacity = cap;  
}

int  CompCache::getDefaultCapacity(void)    
{ 
  return default_capacity; 
}

#endif /* COMP_CACHE_H */
