/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/snprintf.h>
#include <libpandora/conf/unistd.h>
#include <libpandora/conf/fcntl.h>
}

#include <libpandora/fileutil.h>
#include <libpandora/error.h>
#include <libpandora/datalog.h>

DataLog::DataLog(void)
  : fd(-1), off(0)
{
}

DataLog::DataLog(const char *dir, const char *base)
  : fd(-1), off(0)
{
  (void) init(dir, base);
}

DataLog::~DataLog(void)
{
  if (fd > 2) close(fd);
}

bool DataLog::init(const char *dir, const char *base)
{
  if (fd >= 0) close(fd);
  *file = '\0';
  if (base == NULL) return false;
  if (dir == NULL)  dir = "./";

  size_t dlen = strlen(dir);
  if (dlen >= sizeof(file)) return false;
  memcpy(file, dir, dlen);

  size_t blen = strlen(base);
  if (blen >= (dlen + sizeof(file))) return false;
  memcpy(file + dlen, base, blen);
  
  fd = open(file, O_WRONLY|O_CREAT, 0600);
  if (fd < 0) {
    pandora_pwarning(file);
    return false;
  }
  return true;
}

bool DataLog::write(const char *data, int len)
{
  if (fd < 0) return false;

  if (file_writeblock(fd, data, len) != len) {
    pandora_pwarning("write");
    return false;
  }

#if 0
  if (fsync(fd) < 0) {
    pandora_pwarning("fsync");
    return false;
  }
#endif

  return true;
}
