/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef DISPATCHER_H
#define DISPATCHER_H

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/string.h>
#include <strings.h>
#include <libpandora/conf/unistd.h>
}

#include <libpandora/thread.h>
#include <libpandora/stackdesc.h>
#include <libpandora/set.h>

class Component;
class InputComponent;
class Packet;

class Dispatcher : public Thread {
private:
  stack_handle_t	handle;
  Mutex 		mx;
  Condition 		cv;
  StackDesc 		*compStack;
  Component 		*firstComponent;
  InputComponent 	*startComponent;
  bool 			suspended;
  bool 			force;
  bool			deleted;
  bool			root;
  int			refCount;

public:
  Dispatcher(void);
  Dispatcher(stack_handle_t);
  virtual ~Dispatcher(void);

  bool init(StackEntry *se, MultiValue *vals=NULL, int nbvals=0);
  bool use(void);
  bool release(void);
  bool push(Packet *);
  void depend(void) 			{ root = false; }

  bool start(bool threaded);
  bool stop(void);
  bool stop_async(void);
  bool suspend(void);
  bool resume(void);
  bool refresh(StackEntry *, MultiValue *vals=NULL, int nbvals=0);
  void finished(void);

  inline text getID(void);

  inline bool extUse(void);
  inline int  nb_refs(void) 		{ return refCount; }

protected:
  void main(void); 

private:
  inline bool getOption(const text &, const text &, MultiValue *);
  bool setOption(const text &, const text &, const MultiValue &);
  inline bool query(const text &, const text &, MultiValue *);

  bool cleanup(void);
  bool flush(void);
  bool comp_init(void);
  bool comp_start(void);

  friend class Pandora;
};

inline bool Dispatcher::getOption(const text &comp, const text &op,
				  MultiValue *mv) 
{
  if (compStack == NULL) return false;
  return compStack->getOption(comp, op, mv);
}

inline bool Dispatcher::query(const text &comp, const text &arg,
			      MultiValue *mv)
{
  if (compStack == NULL) return false;
  return compStack->query(comp, arg, mv);
}

inline text Dispatcher::getID(void) 
{ 
  return (compStack != NULL ? compStack->getID() : text());  
}

inline bool Dispatcher::extUse(void)
{
  return (refCount > 1);
}

#endif /* DISPATCHER_H */
