/* A Bison parser, made from dispgrammar.yy
   by GNU bison 1.34.  */

#define YYBISON 1  /* Identify Bison output.  */

#define yyparse dispparse
#define yylex displex
#define yyerror disperror
#define yylval displval
#define yychar dispchar
#define yydebug dispdebug
#define yynerrs dispnerrs
#define YYLSP_NEEDED 1

# define	TOK	257
# define	LINE	258
# define	OPTION	259
# define	COMP	260
# define	STACK	261
# define	MACRO	262
# define	ALIAS	263
# define	NUM	264
# define	BOOL	265
# define	FLOAT	266

#line 1 "dispgrammar.yy"

#include <libpandora/global.h>

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include <libpandora/util.h>
#include <libpandora/stackentry.h>
#include <libpandora/stackfactory.h>
#include <libpandora/pandoraentry.h>
#include <libpandora/multivalue.h>

#define YYPARSE_PARAM	parm
#define YYLEX_PARAM	parm

#define pe		((PandoraEntry *)parm)
#define YYDEBUG 1

#define YYERROR_VERBOSE
static void yyerror(char *);

#define YY_DECL int yylex(union yystype *yylval, struct yyltype *yylloc, \
			  void *parm)
YY_DECL;

static char *err_type;
static int err_line = 0;
static void parse_error(PandoraEntry *, int);
static void new_stack(PandoraEntry *, char *);
static void new_component(PandoraEntry *, char *, char *);
static void new_macro(PandoraEntry *, char *);
static void new_option(PandoraEntry *, char *, char *, MultiValue *);

static void add_component(PandoraEntry *, int);
static void add_option(PandoraEntry *);

static void add_param(PandoraEntry *, char *);
static void add_value(PandoraEntry *, MultiValue *);


#line 44 "dispgrammar.yy"
#ifndef YYSTYPE
typedef union yystype {
  int 		 i;
  bool 		 b;
  float 	 f;
  char 		*s;
  MultiValue    *mv;
} yystype;
# define YYSTYPE yystype
#endif

#ifndef YYLTYPE
typedef struct yyltype
{
  int first_line;
  int first_column;

  int last_line;
  int last_column;
} yyltype;

# define YYLTYPE yyltype
#endif

#ifndef YYDEBUG
# define YYDEBUG 0
#endif



#define	YYFINAL		66
#define	YYFLAG		-32768
#define	YYNTBASE	25

/* YYTRANSLATE(YYLEX) -- Bison token number corresponding to YYLEX. */
#define YYTRANSLATE(x) ((unsigned)(x) <= 266 ? yytranslate[x] : 51)

/* YYTRANSLATE[YYLEX] -- Bison token number corresponding to YYLEX. */
static const char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      13,    14,     2,     2,    15,    24,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      21,    20,    22,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    16,     2,    17,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    18,    23,    19,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12
};

#if YYDEBUG
static const short yyprhs[] =
{
       0,     0,     1,     3,     5,     7,     9,    11,    13,    14,
      18,    20,    24,    25,    29,    31,    35,    39,    40,    44,
      45,    49,    51,    55,    57,    61,    63,    66,    68,    71,
      74,    76,    80,    81,    83,    85,    86,    89,    91,    93,
      95,    97,    99,   100,   103,   106,   109,   112,   115,   118,
     120,   122,   124
};
static const short yyrhs[] =
{
      -1,    26,     0,    35,     0,    37,     0,    39,     0,    41,
       0,     1,     0,     0,    13,    28,    14,     0,    49,     0,
      28,    15,    49,     0,     0,    16,    30,    17,     0,    46,
       0,    30,    15,    46,     0,    18,    32,    19,     0,     0,
      32,    48,    47,     0,     0,    16,    34,    17,     0,    41,
       0,    34,    15,    41,     0,    36,     0,    36,    27,    31,
       0,     7,     0,    38,    29,     0,     8,     0,    40,    33,
       0,     6,    43,     0,    42,     0,     5,    43,    45,     0,
       0,    44,     0,     9,     0,     0,    20,    46,     0,    10,
       0,    11,     0,    12,     0,     3,     0,     4,     0,     0,
      47,    21,     0,    47,    22,     0,    47,    13,     0,    47,
      14,     0,    47,    23,     0,    47,    24,     0,    39,     0,
      37,     0,    50,     0,     3,     0
};

#endif

#if YYDEBUG
/* YYRLINE[YYN] -- source line where rule number YYN was defined. */
static const short yyrline[] =
{
       0,    64,    65,    68,    69,    70,    71,    72,    75,    76,
      79,    80,    83,    84,    87,    88,    91,    94,    95,    98,
      99,   102,   103,   106,   107,   110,   113,   116,   119,   122,
     125,   128,   131,   132,   135,   138,   139,   142,   143,   144,
     145,   146,   149,   150,   151,   152,   153,   154,   155,   158,
     159,   162,   165
};
#endif


#if (YYDEBUG) || defined YYERROR_VERBOSE

/* YYTNAME[TOKEN_NUM] -- String name of the token TOKEN_NUM. */
static const char *const yytname[] =
{
  "$", "error", "$undefined.", "TOK", "LINE", "OPTION", "COMP", "STACK", 
  "MACRO", "ALIAS", "NUM", "BOOL", "FLOAT", "'('", "')'", "','", "'['", 
  "']'", "'{'", "'}'", "'='", "'<'", "'>'", "'|'", "'-'", "file", "entry", 
  "param_list", "param_list0", "value_list", "value_list0", "comp_list", 
  "comp_list0", "option_list", "option_list0", "stack", "stack_def", 
  "macro", "macro_def", "component", "component_def", "option", 
  "option_def", "alias", "alias_def", "value", "value_def", "ctors", 
  "com", "param", "param_def", 0
};
#endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives. */
static const short yyr1[] =
{
       0,    25,    25,    26,    26,    26,    26,    26,    27,    27,
      28,    28,    29,    29,    30,    30,    31,    32,    32,    33,
      33,    34,    34,    35,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    43,    44,    45,    45,    46,    46,    46,
      46,    46,    47,    47,    47,    47,    47,    47,    47,    48,
      48,    49,    50
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN. */
static const short yyr2[] =
{
       0,     0,     1,     1,     1,     1,     1,     1,     0,     3,
       1,     3,     0,     3,     1,     3,     3,     0,     3,     0,
       3,     1,     3,     1,     3,     1,     2,     1,     2,     2,
       1,     3,     0,     1,     1,     0,     2,     1,     1,     1,
       1,     1,     0,     2,     2,     2,     2,     2,     2,     1,
       1,     1,     1
};

/* YYDEFACT[S] -- default rule to reduce with in state S when YYTABLE
   doesn't specify something else to do.  Zero means the default is an
   error. */
static const short yydefact[] =
{
       0,     7,    32,    32,    25,    27,     2,     3,     8,     4,
      12,     5,    19,     6,    30,    34,    35,    33,    29,     0,
       0,     0,    26,     0,    28,     0,    31,    52,     0,    10,
      51,    17,    24,    40,    41,    37,    38,    39,     0,    14,
       0,    21,    36,     9,     0,     0,     0,    13,     0,    20,
      11,    16,    50,    49,    42,    15,    22,    18,    45,    46,
      43,    44,    47,    48,     0,     0,     0
};

static const short yydefgoto[] =
{
      64,     6,    20,    28,    22,    38,    32,    45,    24,    40,
       7,     8,     9,    10,    11,    12,    13,    14,    16,    17,
      26,    39,    57,    54,    29,    30
};

static const short yypact[] =
{
      23,-32768,    -1,    -1,-32768,-32768,-32768,-32768,     3,-32768,
       1,-32768,    19,-32768,-32768,-32768,    13,-32768,-32768,    33,
      20,     2,-32768,    32,-32768,     2,-32768,-32768,    12,-32768,
  -32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,    -8,-32768,
      17,-32768,-32768,-32768,    33,    -4,     2,-32768,    32,-32768,
  -32768,-32768,-32768,-32768,-32768,-32768,-32768,    -3,-32768,-32768,
  -32768,-32768,-32768,-32768,    39,    40,-32768
};

static const short yypgoto[] =
{
  -32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
  -32768,-32768,    -2,-32768,     0,-32768,   -23,-32768,    38,-32768,
  -32768,   -24,-32768,-32768,     4,-32768
};


#define	YYLAST		48


static const short yytable[] =
{
      41,    42,     3,   -23,     5,    33,    34,    46,    15,    47,
      58,    59,    35,    36,    37,    51,    19,    21,    60,    61,
      62,    63,    55,    -1,     1,    56,    43,    44,     2,     3,
       4,     5,    48,    25,    49,    23,    27,     2,    31,    65,
      66,    18,     0,    52,     0,    53,     0,     0,    50
};

static const short yycheck[] =
{
      23,    25,     6,     0,     8,     3,     4,    15,     9,    17,
      13,    14,    10,    11,    12,    19,    13,    16,    21,    22,
      23,    24,    46,     0,     1,    48,    14,    15,     5,     6,
       7,     8,    15,    20,    17,    16,     3,     5,    18,     0,
       0,     3,    -1,    45,    -1,    45,    -1,    -1,    44
};
#define YYPURE 1

/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison/bison.simple"

/* Skeleton output parser for bison,

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software
   Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser when
   the %semantic_parser declaration is not specified in the grammar.
   It was written by Richard Stallman by simplifying the hairy parser
   used when %semantic_parser is specified.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

#if ! defined (yyoverflow) || defined (YYERROR_VERBOSE)

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
# if YYLSP_NEEDED
  YYLTYPE yyls;
# endif
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAX (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# if YYLSP_NEEDED
#  define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAX)
# else
#  define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAX)
# endif

/* Relocate the TYPE STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Type, Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	yymemcpy ((char *) yyptr, (char *) (Stack),			\
		  yysize * (YYSIZE_T) sizeof (Type));			\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (Type) + YYSTACK_GAP_MAX;	\
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif /* ! defined (yyoverflow) || defined (YYERROR_VERBOSE) */


#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");			\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).

   When YYLLOC_DEFAULT is run, CURRENT is set the location of the
   first token.  By default, to implement support for ranges, extend
   its range to the last symbol.  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)       	\
   Current.last_line   = Rhs[N].last_line;	\
   Current.last_column = Rhs[N].last_column;
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#if YYPURE
# if YYLSP_NEEDED
#  ifdef YYLEX_PARAM
#   define YYLEX		yylex (&yylval, &yylloc, YYLEX_PARAM)
#  else
#   define YYLEX		yylex (&yylval, &yylloc)
#  endif
# else /* !YYLSP_NEEDED */
#  ifdef YYLEX_PARAM
#   define YYLEX		yylex (&yylval, YYLEX_PARAM)
#  else
#   define YYLEX		yylex (&yylval)
#  endif
# endif /* !YYLSP_NEEDED */
#else /* !YYPURE */
# define YYLEX			yylex ()
#endif /* !YYPURE */


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)
/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
#endif /* !YYDEBUG */

/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif

#if ! defined (yyoverflow) && ! defined (yymemcpy)
# if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#  define yymemcpy __builtin_memcpy
# else				/* not GNU C or C++ */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
#  if defined (__STDC__) || defined (__cplusplus)
yymemcpy (char *yyto, const char *yyfrom, YYSIZE_T yycount)
#  else
yymemcpy (yyto, yyfrom, yycount)
     char *yyto;
     const char *yyfrom;
     YYSIZE_T yycount;
#  endif
{
  register const char *yyf = yyfrom;
  register char *yyt = yyto;
  register YYSIZE_T yyi = yycount;

  while (yyi-- != 0)
    *yyt++ = *yyf++;
}
# endif
#endif

#ifdef YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif
#endif

#line 319 "/usr/share/bison/bison.simple"


/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
#  define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL
# else
#  define YYPARSE_PARAM_ARG YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
# endif
#else /* !YYPARSE_PARAM */
# define YYPARSE_PARAM_ARG
# define YYPARSE_PARAM_DECL
#endif /* !YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
# ifdef YYPARSE_PARAM
int yyparse (void *);
# else
int yyparse (void);
# endif
#endif

/* YY_DECL_VARIABLES -- depending whether we use a pure parser,
   variables are global, or local to YYPARSE.  */

#define YY_DECL_NON_LSP_VARIABLES			\
/* The lookahead symbol.  */				\
int yychar;						\
							\
/* The semantic value of the lookahead symbol. */	\
YYSTYPE yylval;						\
							\
/* Number of parse errors so far.  */			\
int yynerrs;

#if YYLSP_NEEDED
# define YY_DECL_VARIABLES			\
YY_DECL_NON_LSP_VARIABLES			\
						\
/* Location data for the lookahead symbol.  */	\
YYLTYPE yylloc;
#else
# define YY_DECL_VARIABLES			\
YY_DECL_NON_LSP_VARIABLES
#endif


/* If nonreentrant, generate the variables here. */

#if !YYPURE
YY_DECL_VARIABLES
#endif  /* !YYPURE */

int
yyparse (YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  /* If reentrant, generate the variables here. */
#if YYPURE
  YY_DECL_VARIABLES
#endif  /* !YYPURE */

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yychar1 = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack. */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;

#if YYLSP_NEEDED
  /* The location stack.  */
  YYLTYPE yylsa[YYINITDEPTH];
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
#endif

#if YYLSP_NEEDED
# define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
# define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  YYSIZE_T yystacksize = YYINITDEPTH;


  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
#if YYLSP_NEEDED
  YYLTYPE yyloc;
#endif

  /* When reducing, the number of symbols on the RHS of the reduced
     rule. */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;
#if YYLSP_NEEDED
  yylsp = yyls;
#endif
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  */
# if YYLSP_NEEDED
	YYLTYPE *yyls1 = yyls;
	/* This used to be a conditional around just the two extra args,
	   but that might be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yyls1, yysize * sizeof (*yylsp),
		    &yystacksize);
	yyls = yyls1;
# else
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);
# endif
	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (short, yyss);
	YYSTACK_RELOCATE (YYSTYPE, yyvs);
# if YYLSP_NEEDED
	YYSTACK_RELOCATE (YYLTYPE, yyls);
# endif
# undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
#if YYLSP_NEEDED
      yylsp = yyls + yysize - 1;
#endif

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yychar1 = YYTRANSLATE (yychar);

#if YYDEBUG
     /* We have to keep this `#if YYDEBUG', since we use variables
	which are defined only if `YYDEBUG' is set.  */
      if (yydebug)
	{
	  YYFPRINTF (stderr, "Next token is %d (%s",
		     yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise
	     meaning of a token, for further debugging info.  */
# ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
# endif
	  YYFPRINTF (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %d (%s), ",
	      yychar, yytname[yychar1]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#if YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to the semantic value of
     the lookahead token.  This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

#if YYLSP_NEEDED
  /* Similarly for the default location.  Let the user run additional
     commands if for instance locations are ranges.  */
  yyloc = yylsp[1-yylen];
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
#endif

#if YYDEBUG
  /* We have to keep this `#if YYDEBUG', since we use variables which
     are defined only if `YYDEBUG' is set.  */
  if (yydebug)
    {
      int yyi;

      YYFPRINTF (stderr, "Reducing via rule %d (line %d), ",
		 yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (yyi = yyprhs[yyn]; yyrhs[yyi] > 0; yyi++)
	YYFPRINTF (stderr, "%s ", yytname[yyrhs[yyi]]);
      YYFPRINTF (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif

  switch (yyn) {

case 1:
#line 64 "dispgrammar.yy"
{ YYACCEPT; }
    break;
case 2:
#line 65 "dispgrammar.yy"
{ YYACCEPT; }
    break;
case 7:
#line 72 "dispgrammar.yy"
{ parse_error(pe, yylsp[0].first_line); yyerrok; }
    break;
case 14:
#line 87 "dispgrammar.yy"
{ add_value(pe, yyvsp[0].mv); }
    break;
case 15:
#line 88 "dispgrammar.yy"
{ add_value(pe, yyvsp[0].mv); }
    break;
case 18:
#line 95 "dispgrammar.yy"
{ add_component(pe, yyvsp[0].i); }
    break;
case 21:
#line 102 "dispgrammar.yy"
{ add_option(pe); }
    break;
case 22:
#line 103 "dispgrammar.yy"
{ add_option(pe); }
    break;
case 25:
#line 110 "dispgrammar.yy"
{ new_stack(pe, yyvsp[0].s); }
    break;
case 27:
#line 116 "dispgrammar.yy"
{ new_macro(pe, yyvsp[0].s); }
    break;
case 29:
#line 122 "dispgrammar.yy"
{ new_component(pe, yyvsp[-1].s, yyvsp[0].s); }
    break;
case 31:
#line 128 "dispgrammar.yy"
{ new_option(pe, yyvsp[-2].s, yyvsp[-1].s, yyvsp[0].mv); }
    break;
case 32:
#line 131 "dispgrammar.yy"
{ yyval.s = NULL; }
    break;
case 33:
#line 132 "dispgrammar.yy"
{ yyval.s = yyvsp[0].s; }
    break;
case 34:
#line 135 "dispgrammar.yy"
{ yyval.s = yyvsp[0].s; }
    break;
case 35:
#line 138 "dispgrammar.yy"
{ yyval.mv = NULL; }
    break;
case 36:
#line 139 "dispgrammar.yy"
{ yyval.mv = yyvsp[0].mv; }
    break;
case 37:
#line 142 "dispgrammar.yy"
{ yyval.mv = new MultiValue(yyvsp[0].i); }
    break;
case 38:
#line 143 "dispgrammar.yy"
{ yyval.mv = new MultiValue(yyvsp[0].b); }
    break;
case 39:
#line 144 "dispgrammar.yy"
{ yyval.mv = new MultiValue(yyvsp[0].f); }
    break;
case 40:
#line 145 "dispgrammar.yy"
{ yyval.mv = new MultiValue(yyvsp[0].s); __FREE(yyvsp[0].s); }
    break;
case 41:
#line 146 "dispgrammar.yy"
{ yyval.mv = new MultiValue(yyvsp[0].s); __FREE(yyvsp[0].s); }
    break;
case 42:
#line 149 "dispgrammar.yy"
{yyval.i = 0; }
    break;
case 43:
#line 150 "dispgrammar.yy"
{yyval.i |= COMP_DEMUX;  INC_COMP_DEMUX_FACT(yyval.i); }
    break;
case 44:
#line 151 "dispgrammar.yy"
{yyval.i |= COMP_PREMUX; INC_COMP_DEMUX_FACT(yyval.i); }
    break;
case 45:
#line 152 "dispgrammar.yy"
{yyval.i |= COMP_SWITCH; INC_COMP_SWITCH_FACT(yyval.i); }
    break;
case 46:
#line 153 "dispgrammar.yy"
{yyval.i |= COMP_LAST;   INC_COMP_SWITCH_FACT(yyval.i); }
    break;
case 47:
#line 154 "dispgrammar.yy"
{yyval.i |= COMP_INTER;  INC_COMP_SWITCH_FACT(yyval.i); }
    break;
case 48:
#line 155 "dispgrammar.yy"
{yyval.i |= COMP_SIMPLE; }
    break;
case 52:
#line 165 "dispgrammar.yy"
{ add_param(pe, yyvsp[0].s); }
    break;
}

#line 705 "/usr/share/bison/bison.simple"


  yyvsp -= yylen;
  yyssp -= yylen;
#if YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG
  if (yydebug)
    {
      short *yyssp1 = yyss - 1;
      YYFPRINTF (stderr, "state stack now");
      while (yyssp1 != yyssp)
	YYFPRINTF (stderr, " %d", *++yyssp1);
      YYFPRINTF (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;
#if YYLSP_NEEDED
  *++yylsp = yyloc;
#endif

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("parse error, unexpected ") + 1;
	  yysize += yystrlen (yytname[YYTRANSLATE (yychar)]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "parse error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[YYTRANSLATE (yychar)]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exhausted");
	}
      else
#endif /* defined (YYERROR_VERBOSE) */
	yyerror ("parse error");
    }
  goto yyerrlab1;


/*--------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action |
`--------------------------------------------------*/
yyerrlab1:
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;
      YYDPRINTF ((stderr, "Discarding token %d (%s).\n",
		  yychar, yytname[yychar1]));
      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;


/*-------------------------------------------------------------------.
| yyerrdefault -- current state does not do anything special for the |
| error token.                                                       |
`-------------------------------------------------------------------*/
yyerrdefault:
#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */

  /* If its default is to accept any token, ok.  Otherwise pop it.  */
  yyn = yydefact[yystate];
  if (yyn)
    goto yydefault;
#endif


/*---------------------------------------------------------------.
| yyerrpop -- pop the current state because it cannot handle the |
| error token                                                    |
`---------------------------------------------------------------*/
yyerrpop:
  if (yyssp == yyss)
    YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#if YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG
  if (yydebug)
    {
      short *yyssp1 = yyss - 1;
      YYFPRINTF (stderr, "Error: state stack now");
      while (yyssp1 != yyssp)
	YYFPRINTF (stderr, " %d", *++yyssp1);
      YYFPRINTF (stderr, "\n");
    }
#endif

/*--------------.
| yyerrhandle.  |
`--------------*/
yyerrhandle:
  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;
#if YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

/*---------------------------------------------.
| yyoverflowab -- parser overflow comes here.  |
`---------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}
#line 167 "dispgrammar.yy"


void new_stack(PandoraEntry *pentry, char *name)
{
  if (name == NULL) return;
  StackEntry *se = new StackEntry(name);
  if (*name == '*') se->noRun();  
  pentry->setStack(se); 
  __FREE(name); 
}

void new_component(PandoraEntry *pentry, char *name, char *alias)
{
  CompEntry *ce = NULL;
  bool param;
  if (name == NULL) goto out;
  param = (*name == '!');
  ce = new CompEntry(CompEntry::component, (param ? name+1 : name));
  if (param) ce->setParam();
  ce->type = 0;
  pentry->setComponent(ce);
  if (alias != NULL) ce->setAlias(alias);

  __FREE(name); 
 out:
  __FREE(alias);
}

void new_macro(PandoraEntry *pentry, char *name)
{
  if (name == NULL) return;
  bool param = (*name == '!');
  CompEntry *ce  = new CompEntry(CompEntry::macro, (param ? name+1 : name));
  if (param) ce->setParam();
  ce->type = COMP_MACRO;
  pentry->setComponent(ce);

  __FREE(name); 
}

void new_option(PandoraEntry *pentry, char *name, 
		char *alias, MultiValue *mv)
{
  OptionEntry *oe = NULL;
  bool param;
  char *id;
  if (name == NULL) goto out;
  param = (*name == '!');
  id = (param ? name+1 : name);
  oe = new OptionEntry(id);
  if (param) oe->setParam();
  oe->setAlias((alias != NULL) ? alias : id);
  if (mv != NULL) oe->set(*mv);
  pentry->setOption(oe); 
  
  __FREE(name); 
 out:
  __FREE(alias); 
  __DELETE(mv); 
}

void add_component(PandoraEntry *pentry, int type)
{
  StackEntry *se = pentry->stack();
  CompEntry *ce  = pentry->takeComponent();
  if (ce == NULL) return;
  if (se == NULL) goto out;

  ce->type |= type;
  se->pushComponent(*ce); 

 out:
  __DELETE(ce);
}

void add_option(PandoraEntry *pentry)
{
  StackEntry *se = pentry->stack();
  CompEntry *ce = pentry->component();
  OptionEntry *oe  = pentry->takeOption();
  if (oe == NULL) return;
  if (ce == NULL) goto out;

  //if (se != NULL) pandora_debug(se->id << "." << ce->id << "." << oe->id);
  ce->pushOption(*oe);
  if (oe->isParam()) ce->setOpParam();

 out:
  __DELETE(oe);
}

void add_param(PandoraEntry *pentry, char *name)
{
  StackEntry *se = pentry->stack();
  if (se == NULL) goto out;
  if (name != NULL) se->pushParam(name);
  
 out:
  __FREE(name);

}

void add_value(PandoraEntry *pentry, MultiValue *mv)
{
  CompEntry *ce = pentry->component();
  OptionEntry oe;
  if (ce == NULL) goto out;
  if (mv == NULL) return;
  oe.set(*mv);
  ce->pushOption(oe);
  
 out:
  __DELETE(mv);
}

static void yyerror(char *msg)
{
  // pandora_warning(msg);
}

static void parse_error(PandoraEntry *pentry, int line)
{
  pandora_notice("parse error at line " << line); 
  if (pentry->option() != NULL) {
    pandora_notice("near option: " << pentry->option()->id);
  } else if (pentry->component() != NULL) {
    pandora_notice("near component: " << pentry->component()->id);
  } else if (pentry->stack() != NULL) {
    pandora_notice("near stack: " << pentry->stack()->id);
  } else {
    pandora_notice("at top level");
  }
  pentry->reset();  
}
