/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef DYN_BINDINGS_H
#define DYN_BINDINGS_H

#include <libpandora/global.h>

#include <libpandora/map.h>
#include <libpandora/ptrmap.h>
#include <libpandora/text.h>
#include <libpandora/thread.h>
#include <libpandora/dynlibrary.h>
#include <libpandora/dynsymbol.h>

class DynBindings {
private:
  PtrMap<text, DynLibrary *> 	libraries;
  PtrMap<text, DynSymbol *> 	symbols;
  Map<void *, DynSymbol *> 	symUsed;

  static Mutex mx;
  
public:
  DynBindings(void) { }
  ~DynBindings(void);
  
  void *useSymbol(const text &id);
  void releaseSymbol(void *sym, bool force);
  
  bool registerSymbol(const text &name, const text &l);

  bool registerLibrary(const text &id, long version, const text &loc);
  bool registerDependencies(const text &id, const text *d, int n);

  int listSymbols(text *syms, int max_syms);
  int listLibraries(text *libs, int max_libs);

  DynSymbol *getSymbol(const text &name)    { return symbols.atOrNil(name); }
  DynLibrary *getLibrary(const text &name)  { return libraries.atOrNil(name); }

  inline int getNbSymbols(void) const       { return symbols.size(); }
  inline int getNbLibraries(void) const     { return libraries.size(); }

  bool dump(ostream *f = &cout);  

private:
  DynLibrary *newDynLib(const text &id);
};



#endif /* DYN_BINDINGS_H */
