/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

extern "C" {
#include <arpa/inet.h>
#include <libpandora/conf/string.h>
#include <libpandora/conf/unistd.h>
	   }

#include <iostream>
#include <fstream>
#include <libpandora/error.h>
#include <libpandora/encoding.h>

#define NOT_FOUND -2

encoding::encoding(const char *file)
{
  ifstream f(file);
  if(f.bad()){
    pandora_warning("cannot open " << file);
    return;
  }

  char type[256];
  for (int index = 1; f >> type; ++index) {
    //pandora_debug(type << ": " << index);
    data.atPut(text(type), index);
  }
  f.close();
}

int encoding::encode(const char *type)
{
  text key(type);
  return  data.atOrNil(key);
}

/////////////////////////////////////////////////////////////////////

ipreject::ipreject(const char *file)
{
  ifstream f(file);
  if(f.bad()){
    pandora_warning("cannot open " << file);
    return;
  }

  char ip[17];
  char buf[512];
  while(f >> ip){
    in_addr_t ipaddr=inet_addr(ip);
    data.add(ipaddr);
    f.getline(buf,512);
  }
  f.close();
}

bool ipreject::find(in_addr_t addr)
{
  return data.includes(addr);
}


///////////////////////////////////////////////////////////////////////////

ipgroup::ipgroup(const char *file)
{
  ifstream f(file);
  if(f.bad()){
    pandora_warning("cannot open " << file);
    return;
  }

  Map<text, int> idset;

  char ip[17];
  char id[64];
  char buf[512];
  int nid;
  static int index=0;
  
  while(f >> ip){
    in_addr_t ipaddr=inet_addr(ip);
    f >> ws >> id;
    if (!idset.includesKey(id)){
      idset.atPut(id, index);
      ++index;
    }
    nid = idset.at(id);    
    data.atPut(ipaddr, nid);

    f.getline(buf,512);
  }
  f.close();
}


int ipgroup::find(in_addr_t addr)
{
  return data.atOrNil(addr);
}
