/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef ENCODING_H
#define ENCODING_H

#include <libpandora/global.h>

extern "C" {
#include <sys/types.h>
#include <libpandora/conf/string.h>
	   }

#include <iostream>
#include <libpandora/map.h>
#include <libpandora/set.h>
#include <libpandora/text.h>

class encoding {
protected:
  Map<text, int> data;

public:
  encoding(const char *);
  virtual ~encoding(void) { }

  int encode(const char *);  
};

class ipreject {
protected:
  Set<in_addr_t> data;

public:
  ipreject(const char *);
  virtual ~ipreject(void) { }

  bool find(in_addr_t);  
};


class ipgroup {
protected:
  Map<in_addr_t, int> data;

public:
  ipgroup(const char *);
  virtual ~ipgroup(void) { }

   int find(in_addr_t);  
};

#endif /* ENCODING_H */
