/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef ERROR_H
#define ERROR_H

#include <libpandora/global.h>

extern "C" {
#include <errno.h>
#include <assert.h>
#include <stdlib.h>
#include <syslog.h>
}

#include <libpandora/conf/unistd.h>
#include <libpandora/conf/string.h>
#include <iostream>

extern void _assert_(const char *file, int line, 
		     const char *func, const char *expr);
extern void _abort(void);

#ifndef __GNUC__
#define __FUNCTION__ ""
#endif

#define __FUNC__ __FUNCTION__

#ifndef NDEBUG
# define pandora_assert(X) \
     if (!(X)) _assert_(__FILE__, __LINE__, __FUNC__, #X);
#else
# define pandora_assert(X)
#endif

extern void use_syslog(void);
extern int set_verbosity(int);
extern int get_verbosity(void);

extern ostream &_cerr(int, const char *, int, const char *);

#define CERR(L) _cerr(L, __FILE__, __LINE__, __FUNC__) 

#ifdef NDEBUG
#define pandora_debug(MSG)
#else
#define pandora_debug(MSG)	((CERR(LOG_DEBUG)   << MSG << '\n'))
#endif
#define pandora_info(MSG)	((CERR(LOG_INFO)    << MSG << '\n'))
#define pandora_notice(MSG)	((CERR(LOG_NOTICE)  << MSG << '\n'))
#define pandora_warning(MSG)	((CERR(LOG_WARNING) << MSG << '\n'))
#define pandora_pwarning(MSG)	((CERR(LOG_WARNING) << MSG << ": " 	\
				                    << strerror(errno) \
                                                    << '\n'))
#define pandora_error(MSG)   	((CERR(LOG_ERR)     << MSG << '\n'), _abort())
#define pandora_perror(MSG)  	((CERR(LOG_ERR)     << MSG << ": " 	\
                                                     << strerror(errno)	\
                                                     << '\n'), _abort())
#endif /* ERROR_H */
