/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef FILE_UTIL_H
#define FILE_UTIL_H

#include <libpandora/global.h>

extern "C" {
#include <stdio.h>
	   }

extern const char *pandora_dir(void);
extern bool create_empty_dir(const char *);
extern bool create_dir(const char *);
extern bool rmdir_rec(const char *);

extern void rotate_files(const char *, FILE **, time_t);
extern u_short check_sum(u_char *addr, size_t count);
extern char *split_path_list(const char *plist, char *dest, int maxlen);
extern void glob_list(const char *pattern, const char *plist);

extern char *read_in_string(const char *name);

extern bool file_is_modified(const char *name, time_t t);
extern bool file_exists(const char *name);

extern bool make_default_uri(char *uri, int len, 
			     const char *file, const char *var);

int file_readblock(int fd, char *buffer, int nbytes);
int file_writeblock(int fd, const char *buffer, int nbytes);

#endif /* FILE_UTIL_H */


