/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef FUNC_SCHEDULER_H
#define FUNC_SCHEDULER_H

#include <libpandora/scheduler.h>
#include <libpandora/sched_task.h>

#include <map>

class func_scheduler : public scheduler {
private:
  typedef pair<time_t, sched_task_t> elt_t;
  typedef multimap<time_t, sched_task_t> multi_map_t;

  multi_map_t m;

public:
  inline func_scheduler(void);
  inline ~func_scheduler(void) 	{ cleanup(); }

  time_t schedule(time_t, const sched_task_t &);
  void   remove(time_t, const sched_task_t &);
  void   cleanup(void);

protected:
  void   expire(time_t);
};

func_scheduler::func_scheduler(void)
{
}


#endif /* FUNC_SCHEDULER_H */
