/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef GEN_SCAN_COMPONENT_H
#define GEN_SCAN_COMPONENT_H

#include <libpandora/global.h>

#include <libpandora/component.h>
#include <libpandora/packet.h>
  
class Packet;

template <class FromPkt, class ToPkt>
class GenScanComponent : public Component {
public:
  GenScanComponent(void) { }
  virtual ~GenScanComponent(void) { }

  bool add(Packet* obj);

protected:
  virtual bool check(FromPkt *)	{ return false; }
  virtual bool check(ToPkt *) 	{ return false; }  
};


template <class FromPkt, class ToPkt>
bool GenScanComponent<FromPkt, ToPkt>::add(Packet* pkt) 
{
  FromPkt *from = static_cast<FromPkt *>(pkt);

  if (check(from)) {
    cleanPacket(from);
    return false;
  }

  ToPkt *to = new ToPkt(from);
  if (check(to)) {
    cleanPacket(to);
  } else {
    push(to);
  }

  return false;
}

#endif /* GEN_SCAN_COMPONENT_H */
