/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef GLOBAL_RESOURCE_MANAGER_H
#define GLOBAL_RESOURCE_MANAGER_H

#include <libpandora/global.h>

#include <libpandora/map.h>
#include <libpandora/text.h>

class ResourceManager;
class resource_entry_t;

class GlobalResourceManager {
private:
  typedef bool (*action_t)(const char *, void *);
  Map<long, ResourceManager *> 		managers;

public:
  static long grm_id;
  
public:
  GlobalResourceManager(void);
  ~GlobalResourceManager(void);

  void registerManager(long id, action_t a, void *d = NULL);

  bool addResource(long id, const text &, int pri = 1000);
  bool setPriority(long id, const text &, int pri);
  bool deleteResource(long id, const text &);
  int  listResources(long id, resource_entry_t *re, int max_res);

  bool update(long id);
  bool check(long id, const text &);

  bool init(const char *);
};

extern GlobalResourceManager *grm;

#endif /* GLOBAL_RESOURCE_MANAGER_H */
