/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include <libpandora/timersupervisor.h>
#include <libpandora/inputcomponent.h>
#include <libpandora/packet.h>
#include <libpandora/clock.h>

bool InputComponent::push(Packet *pkt) 
{
  pandora_assert (pkt != NULL);
  time_t pktTime = pkt->timeStamp.tv_sec;    
  timerSupervisor->setTime(pktTime);

  --count;
  return Component::push(pkt);
}

bool InputComponent::add(Packet *pkt) 
{
  pandora_error("cannot add packets to this input component");
  cleanPacket(pkt);
  return true;
}

bool InputComponent::pull(Packet *pkt) 
{
  pandora_warning("ignored reply: " << *pkt);
  return false;
}

void InputComponent::start(void) 
{
  in_init();

  while (isActive() && (!process())) {
    if (wsync) {
      if (count == cbkp) {
	timerSupervisor->wall(wallclock->gettime());
      } else {
	cbkp = count;
      }
    }
  } 
}
