/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef OPTION_DESC_H
#define OPTION_DESC_H

#include <libpandora/global.h>
#include <libpandora/complex_option.h>

typedef complex_option *(fpcov)(void);

class option_desc_t {
public:
  enum multi_value_t {
    undefined = -1,
    integer,
    boolean,
    floating,
    textual,
    pointer
  } ;

public:
  multi_value_t  type;
  void 		 *var;

private:
  bool 		 _static;
  fpcov 	 *co_ctor;
  Component 	 *cont;
  complex_option *co;

public:
  inline option_desc_t(void);
  inline option_desc_t(int    *v);
  inline option_desc_t(bool   *v);
  inline option_desc_t(float  *v);
  inline option_desc_t(char  **v);
  inline option_desc_t(void   *v);
  inline option_desc_t(const option_desc_t &x);
  inline option_desc_t &operator=(const option_desc_t &x);
  inline ~option_desc_t(void) 		{ __DELETE(co);   }

  inline void init(fpcov *ctor, Component *cont);
  inline void setStatic(void)		{ _static = true; }
  inline bool isStatic(void);
  inline bool isComplex(void);

  inline void *getReference(const char *);

  inline void cleanup(void)		{ if (co != NULL) co->cleanup(); }
};

option_desc_t::option_desc_t(void) 
  : type(undefined), var(NULL), _static(false), 
    co_ctor(NULL), cont(NULL), co(NULL) 
{ 
}

option_desc_t::option_desc_t(int *v) 
  : type(integer), var((void*)v), _static(false), 
    co_ctor(NULL), cont(NULL), co(NULL) 
{ 
}

option_desc_t::option_desc_t(bool *v) 
  : type(boolean), var((void*)v), _static(false), 
    co_ctor(NULL), cont(NULL), co(NULL) 
{ 
}

option_desc_t::option_desc_t(float *v) 
  : type(floating), var((void*)v), _static(false), 
    co_ctor(NULL), cont(NULL), co(NULL) 
{ 
}

option_desc_t::option_desc_t(char **v) 
  : type(textual), var((void*)v), _static(false), 
    co_ctor(NULL), cont(NULL), co(NULL) 
{ 
}

option_desc_t::option_desc_t(void  *v) 
  : type(pointer), var(v), _static(false), 
    co_ctor(NULL), cont(NULL), co(NULL) 
{ 
}

option_desc_t::option_desc_t(const option_desc_t &x) 
  : type(x.type), var(x.var), _static(x._static), 
    co_ctor(x.co_ctor), cont(x.cont), co(x.co)
{ 
}

option_desc_t &option_desc_t::operator=(const option_desc_t &x) 
{
  type = x.type; var = x.var; _static = x._static; 
  co_ctor = x.co_ctor; cont = x.cont; co = x.co;
  return *this;
}

void option_desc_t::init(fpcov *ctor, Component *comp)
{ 
  co_ctor = ctor;
  cont =    comp;
}

void *option_desc_t::getReference(const char *str)
{
  if (co == NULL) {
    co = (*co_ctor)();
    co->context(cont);
  }

  return (co->set(str) ? co->getReference() : NULL);
}

bool option_desc_t::isStatic(void)
{
  return _static;
}

bool option_desc_t::isComplex(void)
{
  return ((!isStatic()) && (co_ctor != NULL));
}

#endif /* OPTION_DESC_H */
