/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

extern "C" {
#include <arpa/inet.h>
#include <libpandora/conf/string.h>
           }

#include <libpandora/optionentry.h>
#include <libpandora/serialize.h>

size_t OptionEntry::write(char *str, size_t maxlen) const
{
  size_t count = 0;

  serialVar(id);
  serialVar(mv);
  serialVar(alias);
  serialVar(param);

  return count;
}

size_t OptionEntry::read(const char *str)
{
  size_t count = 0;

  unserialVar(id);
  unserialVar(mv);
  unserialVar(alias);
  unserialVar(param);

  return count;
}

void OptionEntry::print(ostream *f) const
{
  *f << '$' << (param ? "!" : "") << id;
  if (alias != id) *f << ":" << alias;
  if (mv.type != MultiValue::undefined) {
    *f << " = ";
    mv.print(f);
  }
}

ostream& operator<<(ostream& f, const OptionEntry &oe)
{
  oe.print(&f);
  return f;
}
