/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include <libpandora/packetfactory.h>
#include <libpandora/dynloader.h>
#include <libpandora/packet.h>

Packet *PacketFactory::createPacket(symbol_id_t ptype)
{
  //pandora_debug("creating packet: " << Packet::get_name(ptype));

  packet_ctor_t func = ctors.atOrNil(ptype);

  if (func == NULL) {
    func = getConstructor(ptype);
    if (func == NULL) {
      pandora_error("invalid packet type: " << ptype);
    }
  }
  return (*func)();
}

bool PacketFactory::load(symbol_id_t ptype)
{
  return (ctors.includesKey(ptype)
	  || (getConstructor(ptype) != NULL));
}

void PacketFactory::clean(void)
{
  for (int i = nctors-1; i >= 0; --i) {
    symbol_id_t ptype = order[i];
    void *sym = (void *)ctors.removeKey(ptype);
    dynloader->unload(sym);
  }
  
  nctors = 0;
}

PacketFactory::packet_ctor_t PacketFactory::getConstructor(symbol_id_t ptype)
{
  packet_ctor_t func = (packet_ctor_t) dynloader->load(ptype);
  if (func == NULL) return NULL;

  if (nctors >= max_ctors) {
    pandora_warning("too many symbols used, increase max_ctors (now="
		    << max_ctors << ")");
    dynloader->unload((void *)func);
    return NULL;
  }
  
  ctors.atPut(ptype, func);
  order[nctors] = ptype;
  ++nctors;

  return func;
}

