/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef PANDORA_ALLOC_H
#define PANDORA_ALLOC_H

#define FORCE_STD_ALLOC

#if (defined NDEBUG || defined FORCE_STD_ALLOC)
# define PANDORA_ALLOC 0
#else
# define PANDORA_ALLOC 1
#endif

#if PANDORA_ALLOC

#ifdef __cplusplus
extern "C" {
#endif

#define xmalloc		pandora_malloc
#define xfree		pandora_free
#define xrealloc	pandora_realloc
#define xstrdup		pandora_strdup

extern void *xmalloc(size_t size);
extern void *xrealloc(void *ptr, size_t new_size);
extern void xfree(void *ptr);
extern char *xstrdup(const char *str);

#ifdef __cplusplus
}
#endif

#ifdef __cplusplus

extern void operator delete(void *p);
extern void *operator new(size_t lbs);
#endif

#else

#include <stdlib.h>

#define xmalloc		malloc
#define xfree		free
#define xrealloc	realloc
#define xstrdup		strdup

#endif /* PANDORA_ALLOC */

#define __DELETE(x)	  do { if (x!=NULL) { delete x; x = NULL; } } while(0)
#define __DELETE_ARRAY(x) do { if (x!=NULL) { delete[] x; x = NULL;}} while(0)
#define __FREE(x)	  do { if (x!=NULL) { xfree(x); x = NULL; } } while(0)

#endif /* PANDORA_ALLOC_H */
