/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef PIPE_H
#define PIPE_H

#include <libpandora/global.h>

#include <list>
#include <libpandora/thread.h>


template<class elt_t>
class Pipe
{
private:
  typedef list<elt_t> list_t;
  typedef Pipe<elt_t> pipe_t;

private:
  Semaphore sema;
  list_t l;
  int nelts;

public:
  Pipe(void) : nelts(0) { }
  ~Pipe(void) { }

public:
  void put(elt_t data) {
    sema.lock();
    l.push_back(data);
    ++nelts;
    sema._signal();
    sema.unlock();
  }

  elt_t get(void) {
    sema.lock();
    sema._wait();
    elt_t elt = l.front();
    l.pop_front();
    --nelts;
    sema.unlock();
    return elt;
  }

  size_t size(void) const {
    return nelts;
  }

  bool isEmpty(void) {
    return l.empty();
  }
};


#endif /* PIPE_H */
