/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <libpandora/conf/time.h>
#include <libpandora/conf/poll.h>

void bzero();


int
poll(fds, nfds, timo)
     struct pollfd *fds;
     
     unsigned int nfds;
     int timo;
{
  struct timeval timeout, *toptr;
  
  fd_set ifds, ofds, efds, *ip, *op, *ep;
  int i, rc, n;
  FD_ZERO(&ifds);
  FD_ZERO(&ofds);
  
  FD_ZERO(&efds);
  for (i = 0, n = -1, op = ip = 0; i < nfds; ++i) {
    fds[i].revents = 0;
    
    if (fds[i].fd < 0)
      continue;
    if (fds[i].fd > n)
      n = fds[i].fd;
    
    if (fds[i].events & (POLLIN|POLLPRI)) {
      ip = &ifds;
      FD_SET(fds[i].fd, ip);
    }
    
    if (fds[i].events & POLLOUT) {
      op = &ofds;
      FD_SET(fds[i].fd, op);

    }
    FD_SET(fds[i].fd, &efds);
  }
  if (timo < 0)

    toptr = 0;
  else {
    toptr = &timeout;
    timeout.tv_sec = timo / 1000;

    timeout.tv_usec = (timo - timeout.tv_sec * 1000) * 1000;
  }
  rc = select(++n, ip, op, &efds, toptr);

  if (rc <= 0)
    return rc;

  for (i = 0, n = 0; i < nfds; ++i) {

    if (fds[i].fd < 0) continue;
    if (fds[i].events & (POLLIN|POLLPRI) && FD_ISSET(i, &ifds))
      fds[i].revents |= POLLIN;
    if (fds[i].events & POLLOUT && FD_ISSET(i, &ofds))

      fds[i].revents |= POLLOUT;
    if (FD_ISSET(i, &efds))
      /* Some error was detected ... should be some way to know. */

      fds[i].revents |= POLLHUP;
  }
  return rc;
}
