/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef PTRMAP_H
#define PTRMAP_H

#include <libpandora/global.h>

#include <libpandora/set.h>
#include <libpandora/association.h>

#define GENERIC	template<class Key, class Val> inline
#define PTRMAP	PtrMap<Key, Val>

template<class Key, class Val>
class PtrMap : public Map<Key, Val>
{
public:
  PtrMap(void) { }
  virtual ~PtrMap(void) { cleanup(); }

public:
  void	       removeDelKey(const Key &key);
  void	       cleanup(void);
};


//
// INLINE IMPLEMENTATION
//

// Remove key (and its associated value) from the ptrmap.

GENERIC void PTRMAP::removeDelKey(const Key &key)
{
  //pandora_debug("removing key: " << key << " (" << size() << ")");
  Val ptr = removeKey(key);
  __DELETE(ptr);
}

GENERIC void PTRMAP::cleanup(void)
{
  Val ptr;
  valuesDo(*this, ptr) __DELETE(ptr);
  clear();
}

#undef GENERIC
#undef PTRMAP


#endif /* PTRMAP_H */
