/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef QUEUE_H
#define QUEUE_H

#include <libpandora/global.h>

#include <libpandora/error.h>

// note: elt_t must have a default constructor

template <class elt_t> class Queue
{
public:
  elt_t *elements;
  int head, tail;
  int capacity;

public:  
  Queue(int c= 32) : head(0), tail(0), capacity((c < 1) ? 1 : c) {
    elements= new elt_t[capacity];
  }
  
  ~Queue(void) { __DELETE_ARRAY(elements); }

  void reset(void) { head= tail= 0; }

  bool isEmpty(void) { return head == tail; }

  int size(void) { 
    int size = tail-head;
    return (size < 0 ? size + capacity : size); 
  }

  elt_t add(elt_t elt) {
    int newTail= tail + 1;
    if (newTail == capacity) newTail= 0;
    if (newTail == head) {
      // the logic is too horrible to contemplate: just build a new queue
      Queue<elt_t> newQueue(capacity*2);
      for (int i= capacity-1; i != 0; --i) newQueue.add(remove());
      pandora_assert(isEmpty());
      elt_t *oldElements= elements;
      elements= newQueue.elements;
      capacity= newQueue.capacity;
      head= newQueue.head;
      tail= newQueue.tail;
      newQueue.elements= oldElements;	// deleted on exit from scope
      newTail= tail+1;
      if (newTail == capacity) newTail= 0;
      pandora_assert(newTail != head);
    }
    elements[tail]= elt;
    tail= newTail;
    return elt;
  }

  elt_t remove(void) {
    pandora_assert (head != tail);
    int oldHead= head;
    if (++head == capacity) head= 0;
    return elements[oldHead];
  }

  elt_t &first(void) {
    pandora_assert(head != tail);
    return elements[head];
  }

  elt_t &last(void) {
    pandora_assert(head != tail);
    int prev = (tail > 0) ? tail - 1 : capacity - 1;
    return elements[prev];
  }
};

#define qElementsDo(QUEUE, ELT)					\
  for (int _9 = (QUEUE).head;					\
       _9 < ((QUEUE).tail);					\
       _9 = (_9 == ((QUEUE).capacity - 1)) ? 0 :  _9 + 1)	\
      if ((ELT) = (QUEUE).elements[_9], 1)

#endif /* QUEUE_H */
