/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#define RESOURCE_DEBUG 0

extern "C" {
#include <libpandora/conf/string.h>
}

#include <libpandora/resource.h>
#include <libpandora/resource_entry.h>
#include <libpandora/resource_types.h>
#include <libpandora/clock.h>

resource_t *resource_t::parse(const text &uri)
{
  if (uri.isNull()) return NULL;

  resource_t *res = NULL;
  
  char *pos = strchr(uri.data(), ':');
  if (pos == NULL) { // assumes it is a file name
    res = new file_resource_t(uri);
  } else {
    char s[16];
    int slen = pandora_min(pos - uri.data(), (int)(sizeof(s)-1));
    memcpy(s, uri.data(), slen);
    s[slen] = '\0';
    
#if RESOURCE_DEBUG
    pandora_debug("found URI scheme: " << s);
#endif
    
    if (strcmp(s, "file") == 0) {
      res = new file_resource_t(pos+1);
    } else if (strcmp(s, "string") == 0) {
      res =  new string_resource_t(pos+1);
    } else if (strcmp(s, "http") == 0) {
      res = new http_resource_t(uri);
    } else {
      pandora_warning("unknown scheme: " << s << " [" << uri << "]");
    }
  }
  
  if (res != NULL) {
    if (res->scheme == chars) {
      char *tmp = strchr(uri.data(), '\n');
      int sz = pandora_min(((tmp == NULL) ? 63 : (tmp - uri.data())),
			   uri.length());
      res->uri.init(uri.data(), sz);
    } else {
      res->uri.init(uri.data(), uri.length());
    }
    //pandora_debug(res->uri);
  }

  return res;
}

bool resource_t::fetch(char **str)
{
  if (str == NULL) return false;

  last_fetch = wallclock->gettime();

#if RESOURCE_DEBUG
  pandora_debug("fetching (-> string)");
#endif

  return doFetchString(str);
}

bool resource_t::fetch(char *name, int len)
{
  if (name == NULL) return false;

  last_fetch = wallclock->gettime();

#if RESOURCE_DEBUG
  pandora_debug("fetching (-> file)");
#endif

  return doFetchFile(name, len);
}

void resource_t::fillEntry(resource_entry_t *re)
{
  if (re == NULL) return;
  re->uri = uri;
  re->priority = priority;
}
