/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef RESOURCE_H
#define RESOURCE_H

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/time.h>
#include <stdlib.h>
}

#include <libpandora/text.h>

class resource_entry_t;

class resource_t {
protected:
  enum scheme_t { 
    undefined = -1, 
    chars,
    file, 
    http 
  } 		scheme;
  time_t 	last_fetch;
  int		priority;
  text		uri;

public:
  resource_t(scheme_t s) : scheme(s), last_fetch(0), priority(0)	{ }
  virtual ~resource_t(void) 						{ }
  inline resource_t(const resource_t &x);
  inline resource_t &operator =(const resource_t &x);

  static resource_t *parse(const text &);

  inline static bool fetch(const text &, char **);
  inline static bool fetch(const text &, char *, int);
  inline static bool fetch(const text &uri, text &t);

  void fillEntry(resource_entry_t *re);

  bool fetch(char **);
  bool fetch(char *, int);
  inline bool fetch(text &t);

  void setPriority(int pri) 				{ priority = pri; }
  int getPriority(void) 				{ return priority; }

  text getURI(void) 					{ return uri; }

  virtual bool doFetchString(char **) 	= 0;
  virtual bool doFetchFile(char *, int) = 0;
  virtual bool isModified(void)  	= 0;
};

bool resource_t::fetch(const text &uri, char **s) 
{
  resource_t *res = parse(uri);
  if (res == NULL) return false;
  bool ret = res->fetch(s);
  __DELETE(res);
  return ret;
}

bool resource_t::fetch(const text &uri, char *name, int len) 
{
  resource_t *res = parse(uri);
  if (res == NULL) return false;
  bool ret = res->fetch(name, len);
  __DELETE(res);
  return ret;
}

bool resource_t::fetch(const text &uri, text &t) 
{
  resource_t *res = parse(uri);
  if (res == NULL) return false;
  bool ret = res->fetch(t);
  __DELETE(res);
  return ret;
}

bool resource_t::fetch(text &t) {
  t.init(PATH_MAX);
  bool ret = fetch(t.data(), t.length()); 
  t.update();
  return ret;
}

resource_t::resource_t(const resource_t &x) 
  : scheme(x.scheme), last_fetch(x.last_fetch), 
  priority(x.priority), uri(x.uri)
{
}

resource_t &resource_t::operator =(const resource_t &x)
{
  scheme = x.scheme; last_fetch = x.last_fetch;
  priority = x.priority; uri = x.uri; 
  return *this;
}


#endif /* RESOURCE_H */
