/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef RESOURCE_ENTRY_H
#define RESOURCE_ENTRY_H

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/time.h>
#include <stdlib.h>
}

#include <libpandora/text.h>
#include <libpandora/serialize.h>

class resource_entry_t {
public:
  text		uri;
  int		priority;

public:
  resource_entry_t(void) : priority(0)				{ }
  virtual ~resource_entry_t(void) 				{ }
  inline resource_entry_t(const resource_entry_t &x);
  inline resource_entry_t &operator =(const resource_entry_t &x);
};


resource_entry_t::resource_entry_t(const resource_entry_t &x) 
  : uri(x.uri), priority(x.priority) 
{
}

resource_entry_t &resource_entry_t::operator =(const resource_entry_t &x)
{
  uri = x.uri; priority = x.priority;
  return *this;
}

inline void serialize(char *str, size_t &count, 
		 const size_t maxlen, const resource_entry_t *re) 
{
  serialVar(re->uri);
  serialVar(re->priority);
}

inline void unserialize(const char *str, size_t &count, resource_entry_t *re)
{
  unserialVar(re->uri);
  unserialVar(re->priority);
}

#endif /* RESOURCE_ENTRY_H */
