/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include <libpandora/resource_types.h>
#include <libpandora/fileutil.h>

bool string_resource_t::doFetchString(char **s)
{
#if RESOURCE_DEBUG
  pandora_debug("fetching string: " << str);
#endif
  if (str.isNull()) return false;
  *s = xstrdup(str.data());
  return (*s != NULL);
}

bool string_resource_t::doFetchFile(char *name, int len)
{
#if 0
  if (name == NULL) return false;
  if (str.isNull()) return false;

  char *n = tempnam("/var/tmp", "pandora");
  if (n == NULL) return false;
  strncpy(name, n, len);
  name[len] = '\0';
  xfree(n);

  FILE *f = fopen(name, "w");
  if (f == NULL) return false;
  int p = fwrite(str.data, sizeof(char), str.len, f);
  fclose(f);

  return (p == str.len);
#else
  return false;
#endif
}

bool file_resource_t::doFetchString(char **str)
{
  if (path.isNull()) return false;
  *str = read_in_string(path.data());
  return (*str != NULL);
}

bool file_resource_t::doFetchFile(char *name, int len)
{
  if (name == NULL) 		return false;
  if (path.isNull()) 		return false;
  if ((path.length()-1) > len) 	return false;

  strncpy(name, path.data(), len);
  return true;
}

bool file_resource_t::isModified(void)
{
  return file_is_modified(path.data(), last_fetch);
}

bool http_resource_t::doFetchString(char **str)
{
  if (url.isNull()) return false;
  return (url.fetchString(str) > 0);
}

bool http_resource_t::doFetchFile(char *name, int len)
{
  if (name == NULL) 		return false;
  if (url.isNull()) 		return false;
  return (url.fetchFile("/var/tmp", name, len) > 0);
}
