/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef SCHED_MANAGER_H
#define SCHED_MANAGER_H

#include <libpandora/global.h>

#include <libpandora/map.h>
#include <libpandora/scheduler.h>

typedef int sched_handle_t;
#define NIL_SCHED_HANDLE ((stack_handle_t) 0)

class sched_manager_t {
public:
  struct event_t {
    sched_manager_t	*smgr;
    sched_handle_t	handle;
    sched_task_func_t 	*exp_func;
    sched_task_func_t 	*rem_func;
    void 		*data;
    int 		timeout;
    bool 		resched;
    bool		expired;
  };

private:
  Map<sched_handle_t, sched_task_t> 	events;
  scheduler 				*sched;
  sched_handle_t 			curhandle;

public:
  inline sched_manager_t(void);
  inline sched_manager_t(scheduler *s);
  inline ~sched_manager_t(void) 		{ cleanup(); }

  sched_handle_t schedule(const sched_task_t &task, int timeout, bool resched);
  void reschedule(sched_handle_t, int timeout, bool resched);
  void remove(sched_handle_t);

  inline void setScheduler(scheduler *s) 	{ sched = s; }
  void cleanup(void);

private:
  inline sched_handle_t nextHandle(void)	{ return (++curhandle); }
  void remove(sched_handle_t, sched_task_t &);
};

sched_manager_t::sched_manager_t(void) 
  : sched(NULL), curhandle(NIL_SCHED_HANDLE)
{
}

sched_manager_t::sched_manager_t(scheduler *s) 
  : sched(s), curhandle(NIL_SCHED_HANDLE)
{
}

#endif /* SCHED_MANAGER_H */
