/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/scheduler.h>

scheduler::~scheduler(void) 			
{ 
#if TDEBUG
  pandora_assert ((inserted - removed - expired) == remaining);
  if (remaining != 0) {
    pandora_warning("Timers have not been collected");
    pandora_debug(localTime  << "[timers] "
		  << remaining
		  << " (" << inserted
		  << ", " << removed
		  << ", " << expired << ")");
#endif
}

void scheduler::print(void)
{
#if DEBUG_SCHED
  pandora_debug(localTime  << "[timers] "
		<< remaining
		<< " (" << inserted
		<< ", " << removed
		<< ", " << expired << ")");
#endif
}
