/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef SCHEDULER_H
#define SCHEDULER_H

#include <libpandora/global.h>

#include <libpandora/error.h>
#include <libpandora/sched_task.h>

#define DEBUG_SCHED 0

class scheduler {
protected:
  time_t	localTime;

#if DEBUG_SCHED
  int inserted, removed, expired, remaining;
#endif

public:
  inline  scheduler(void);
  virtual ~scheduler(void);

  inline  void   set_time(time_t);
  inline  time_t get_time(void) 			{ return localTime; }
  virtual time_t schedule(time_t, const sched_task_t &) = 0;
  virtual void   remove(time_t, const sched_task_t &)   = 0;
  virtual void   cleanup(void) 			        = 0;

  void print(void);

protected:
  virtual void   expire(time_t t)	   	        = 0;
};

inline scheduler::scheduler(void) 
  : localTime(0)
#if DEBUG_SCHED
    , inserted(0), removed(0), expired(0), remaining(0)
#endif
{ 
}

inline void scheduler::set_time(time_t t)
{
  if (localTime == 0) localTime = t;
  if (t > localTime) {
    expire(t);
#if 0 
   if (localTime != t) {
      pandora_error("failed to set local time: " << localTime 
		    << " (" << t << ")");
    }
#endif
  }
}


#endif /* SCHEDULER_H */
