#include <global.h>

extern "C" {
#include <sys/types.h>

#ifdef HAVE_SIGSET
#include <pthread.h>
#ifndef __USE_UNIX98
#define __USE_UNIX98
#endif
#endif

#include <signal.h>

#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#ifdef HAVE_SIGACTION
#include <libpandora/conf/string.h>
#endif

#ifdef HAVE_SIGSET
#undef __USE_UNIX98
#endif
	   }

#include <libpandora/setsignal.h>

/*
 * An os independent signal() with BSD semantics, e.g. the signal
 * catcher is restored following service of the signal.
 *
 * When sigset() is available, signal() has SYSV semantics and sigset()
 * has BSD semantics and call interface. Unfortunately, Linux does not
 * have sigset() so we use the more complicated sigaction() interface
 * there.
 *
 * Did I mention that signals suck?
 */

extern "C" {

RETSIGTYPE (*setsignal (int sig, sigfunc_t func))(int)
{
#ifdef HAVE_SIGACTION
	struct sigaction old, new_sa;

	memset(&new_sa, 0, sizeof(new_sa));
	new_sa.sa_handler = func;
#ifdef SA_RESTART
	new_sa.sa_flags |= SA_RESTART;
#endif
	if (sigaction(sig, &new_sa, &old) < 0)
		return (SIG_ERR);
	return (old.sa_handler);

#else
#ifdef HAVE_SIGSET
	return (sigset(sig, func));
#else
	return (signal(sig, func));
#endif
#endif
}

	   }
