/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef SMART_PTR_H
#define SMART_PTR_H

#include <libpandora/global.h>

template <class T>
class smart_ptr {
private:
  const T *_ptr;

public:
  inline smart_ptr(void) : _ptr(NULL) 				{ }
  inline smart_ptr(const T *p) : _ptr(p)			{ }
  inline smart_ptr(const T &o) : _ptr(&o)			{ }
  inline ~smart_ptr(void) 					{ }
  inline smart_ptr(const smart_ptr<T> &x) : _ptr(x._ptr)	{ }

  inline smart_ptr<T> &operator=(const smart_ptr<T> &x);
  inline operator long() const;
  inline bool operator ==(const smart_ptr<T> &) const;
  inline bool operator !=(const smart_ptr<T> &x) const;
  
  inline T *ptr(void) 			      { return (T *)_ptr; }
};

template <class T>
smart_ptr<T> &smart_ptr<T>::operator=(const smart_ptr<T> &x) 
{ 
  _ptr = x._ptr; 
  return *this;
}

template <class T>
smart_ptr<T>::operator long() const
{
  return (_ptr != NULL ? (long) (*_ptr) : 0L);
}

template <class T>
bool smart_ptr<T>::operator ==(const smart_ptr<T> &x) const
{
  return ((!_ptr && !x._ptr) 
	  || (_ptr && x._ptr && (*_ptr == *(x._ptr))));
}

template <class T>
bool smart_ptr<T>::operator !=(const smart_ptr<T> &x) const 
{ 
  return !operator ==(x);
}
#endif /* SMART_PTR_H */
