/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

extern "C" {
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
}

#include <libpandora/socketselect.h>

bool SocketSelect::incomming(int fd, void *me) 
{
  pandora_debug("new connection");

  SocketSelect *This = (SocketSelect *)me;
  pandora_assert(fd == This->listen_fd);

  struct sockaddr_in inet_addr;
  struct sockaddr_un unix_addr;
  struct sockaddr *saddr = 
    (This->inet ? (sockaddr *)&inet_addr : (sockaddr *)&unix_addr);

  socklen_t len = sizeof(*saddr);
  int nfd = accept(fd, saddr, &len);
  if (nfd < 0)
    pandora_perror("accept");

  This->registerFd(nfd, me, &nc, &ec);
  return false;
}

bool SocketSelect::nc(int fd, void *me) 
{
  SocketSelect *This = (SocketSelect *)me;

  if (!This->connected) {
    struct sockaddr_in inet_addr;
    struct sockaddr_un unix_addr;
    struct sockaddr *saddr = 
      (This->inet ? (sockaddr *)&inet_addr : (sockaddr *)&unix_addr);

    socklen_t len;
    char buf[1];
    if (recvfrom(fd, buf, 0, MSG_PEEK, saddr, &len) < 0) {
      pandora_warning("recvfrom: " << strerror(errno));
    } else {
      if (connect(fd, saddr, len) < 0) {
	pandora_warning("connect: " << strerror(errno));
      } else {
	This->connected = true;
      }
    }
  }
  bool status = (*(This->process))(fd, This->user_data);
  pandora_debug("process returned: " << status);
  return status;
}

void SocketSelect::ec(int fd, void *me) 
{
  pandora_debug("closed connection");
  if (close(fd) != 0) pandora_perror("close");
}
