/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

extern "C" {
#include <stdio.h>
#include <assert.h>
#include <libpandora/conf/string.h>
	   }

#include <libpandora/stackfactory.h>
#include <libpandora/pandoraentry.h>
#include <libpandora/stackentry.h>
#include <libpandora/compentry.h>
#include <libpandora/optionentry.h>
#include <libpandora/dispgrammar.h>

extern void init_flex_buffer(FILE *);
extern void init_flex_buffer(const char *);
extern int  dispparse(void *parm);
extern int  displex(union yystype *yylval, struct yyltype *yylloc, void *parm);
extern int dispdebug;
  
Mutex StackFactory::mx;

StackFactory::StackFactory(const char *str) : ok(false)
{
  mx.lock();

  if (str == NULL) {
    pandora_warning("invalid configuration string");
  } else {      
    init_flex_buffer(str); 
    ok = true;
  }
  dispdebug = 0;
}

StackFactory::~StackFactory(void) 
{ 
  init_flex_buffer((const char *)NULL);
  ok = false;
  mx.unlock();
}

bool StackFactory::parse(PandoraEntry *pe) 
{
  pandora_assert(pe != NULL);
  if (!ok) return false;
  pe->reset();
  return (dispparse((void *)pe) == 0);
}

StackEntry *StackFactory::parseStack(void) 
{
  PandoraEntry pe;

  if (parse(&pe)) return pe.takeStack();
  return NULL;
}

CompEntry *StackFactory::parseComp(void) 
{
  PandoraEntry pe;
  if (parse(&pe)) return pe.takeComponent();
  return NULL;
}

OptionEntry *StackFactory::parseOption(void) 
{
  PandoraEntry pe;
  if (parse(&pe)) return pe.takeOption();
  return NULL;
}

int StackFactory::parseValue(MultiValue *mv)
{
  if (mv == NULL) return -1;
  union yystype yylval;
  struct yyltype yylloc;
  switch(displex(&yylval, &yylloc, NULL)) {
  case NUM: 	mv->set(yylval.i); return 1;
  case BOOL: 	mv->set(yylval.b); return 1;
  case FLOAT: 	mv->set(yylval.f); return 1;
  case TOK: 	mv->set(yylval.s); __FREE(yylval.s); return 1;
  case LINE: 	mv->set(yylval.s); __FREE(yylval.s); return 1; 
  case 0:	return -1;
  default:      break;
  }
  return 0;
}
