/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef STAT_FUNCS_H
#define STAT_FUNCS_H

#include <libpandora/global.h>
#include <libpandora/algo_funcs.h>

enum stat_op_t { stat_undefined = -1, stat_init, stat_update, stat_finish };

const static int stat_storage_size = 16;

typedef bool (*stat_func_t)(stat_op_t op, int &val, 
			    int storage[stat_storage_size]);

#endif /* STAT_FUNCS_H */
