/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef SWITCH_COMPONENT_H
#define SWITCH_COMPONENT_H

#include <libpandora/global.h>

#include <libpandora/component.h>
#include <libpandora/packet.h>

class SwitchComponent : public Component {
public:  
  SwitchComponent() {}
  virtual ~SwitchComponent() {}
  
  virtual int _switch(Packet *) = 0;
  inline bool add(Packet *pkt);
};

bool SwitchComponent::add(Packet *pkt) 
{
  int sw = _switch(pkt);
  if (sw < -1) sw = -1;
 
  switch(sw) {
  case -1:	cleanPacket(pkt); break;
  case 0:	push(pkt); break;
  default:	push(pkt, sw); break;
  }

  return false;
}

#endif /* SWITCH_COMPONENT_H */
