/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef TIMER_SUPERVISOR_H
#define TIMER_SUPERVISOR_H

#include <libpandora/global.h>

#include <libpandora/thread.h>
#include <libpandora/scheduler.h>

class TimerSupervisor {
private:
  time_t wcTime, wcLocTime;
  scheduler *sched;

public:
  TimerSupervisor(void);
  virtual ~TimerSupervisor(void);

  inline void   setTime(time_t t) 	    { sched->set_time(t); }
  inline time_t getTime(void) 	    	    { return sched->get_time(); }
  inline void   wall(time_t wt);

  void cleanup(void);

  inline scheduler *getScheduler(int n = 0) { return sched; }
};

void TimerSupervisor::wall(time_t wt) 
{
  time_t current_time = getTime();
  if (current_time == 0) return;

  if (wcLocTime != 0)
    setTime(wcLocTime + (wt - wcTime));

  wcLocTime = current_time;
  wcTime = wt;
}

#endif /* TIMER_SUPERVISOR_H */
