/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef TRIPLET_H
#define TRIPLET_H

template <class T1, class T2, class T3>
struct triplet {
  typedef T1 first_type;
  typedef T2 second_type;
  typedef T3 third_type;

  T1 first;
  T2 second;
  T3 third;
  triplet() : first(T1()), second(T2()), third(T3()) {}
  triplet(const T1& a, const T2& b, const T3& c) : first(a),
    second(b), third(c) {}

#ifdef __STL_MEMBER_TEMPLATES
  template <class U1, class U2, class U3>
  triplet(const triplet<U1, U2, U3>& p) : first(p.first), second(p.second),
    third(p.third) {}
#endif
};

template <class T1, class T2, class T3>
inline bool operator==(const triplet<T1, T2, T3>& x,
		       const triplet<T1, T2, T3>& y) { 
  return x.first == y.first && x.second == y.second && x.third == y.third; 
}

template <class T1, class T2, class T3>
inline bool operator<(const triplet<T1, T2, T3>& x,
		      const triplet<T1, T2, T3>& y) { 
  return x.first < y.first || (!(y.first < x.first) && x.second < y.second)
    || (!(y.first < x.first) && !(y.second < x.second) && x.third < y.third); 
}

template <class T1, class T2, class T3>
inline triplet<T1, T2, T3> make_triplet(const T1& x, const T2& y, const T3& z){
  return triplet<T1, T2, T3>(x, y, z);
}

#endif /* TRIPLET_H */
