/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef UTIL_H
#define UTIL_H

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/time.h>
#include <libpandora/conf/param.h>
#include <libpandora/conf/string.h>
#include <stdlib.h>
#include <stdio.h>
	   }

#include <iostream>
#include <map>

class ofstream;

#define pandora_min(a,b) ((a)>(b)?(b):(a))
#define pandora_max(a,b) ((b)>(a)?(b):(a))

#ifndef SEQ_ADD
#define SEQ_ADD(a,b)    ((u_int32_t)((long)(a)+(long)(b)))
#endif
#ifndef SEQ_SUB
#define SEQ_SUB(a,b)    ((int32_t)((long)(a)-(long)(b)))
#endif

struct tok {
  int v;	/* value */
  char *s;	/* string */
};

extern char *skip_ws(char *);
extern char *tok2str(const struct tok *, const char *, int);
extern char *intoa(u_int32_t);
extern ostream &operator<< (ostream &, const struct in_addr & );

u_short check_sum(u_char *addr, size_t count);

extern long string_hash(const char *str);
extern bool string_eq(const char *s1, const char *s2);

extern void sleep_until(const struct timeval &);

template <class key_t, class value_t> inline 
typename multimap<key_t, value_t>::iterator multimap_find
(multimap<key_t, value_t> &mulmap, 
 const key_t &key, 
 const value_t &val)
{
  typename multimap<key_t, value_t>::iterator ptr;
  typename multimap<key_t, value_t>::iterator first, last;

  pair<typename multimap<key_t, value_t>::iterator, 
    typename multimap<key_t, value_t>::iterator> p 
    = mulmap.equal_range(key);

  first = p.first;
  last =  p.second;

  for (ptr = first; ptr != last; ++ptr) {
    if (ptr->second == val) return ptr;
  }
  return mulmap.end();
}

template <class key_t, class value_t> inline 
void multimap_erase
(multimap<key_t, value_t> &mulmap, const key_t &key, const value_t &val)
{
  typename multimap<key_t, value_t>::iterator ptr;
  typename multimap<key_t, value_t>::iterator first, last;

  pair<typename multimap<key_t, value_t>::iterator, 
    typename multimap<key_t, value_t>::iterator> 
    p = mulmap.equal_range(key);

  first = p.first;
  last =  p.second;

  for (ptr = first; ptr != last; ++ptr) {
    if (ptr->second == val) {
      mulmap.erase(ptr);
      return;
    }
  }
}

inline long string_hash(const char *str)
{
  if (str == NULL) return 0;
  long h = 0; 
  const char *tmp = str;
  for (/* empty */; *tmp; ++tmp)
    h = 117*h + *tmp;
  return h;
}

inline bool string_eq(const char *s1, const char *s2)
{
  return (!s1 && !s2) || (s1 && s2 && !strcmp(s1, s2));
}

#endif /* UTIL_H */


