/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef WRAPPER_H
#define WRAPPER_H

#include <libpandora/global.h>

typedef struct DynLoader* dynloader_t ;
typedef struct Pandora* pandora_t ;
typedef struct Component* component_t ;

#ifdef __cplusplus
extern "C" {
#endif
  extern void new_dynloader(const char *);
  extern void delete_dynloader(void);
  extern void new_pandora(const char *);
  extern void delete_pandora(void);

  extern stack_handle_t pandora_start(const char *stk, int threaded);
  extern int pandora_stop(stack_handle_t sh);
  extern int pandora_suspend(stack_handle_t sh);
  extern int pandora_resume(stack_handle_t sh);

  extern int pandora_set_stack(const char *stk);
  extern stack_handle_t pandora_use_stack(const char *stk);
  extern int pandora_set_option(const char *stk, const char *comp, 
				const char *op, const char *val);
  extern int pandora_set_live_option(stack_handle_t sh, const char *comp, 
				     const char *op, const char *val);
  extern void pandora_poll(void);
  extern void pandora_poll_stack(stack_handle_t sh);
  
  extern int dynloader_register_symbol(const char *name, const char *lib,
				       const char *prefix);
  extern int dynloader_register_library(const char *id, long version,
					const char *loc,
					const char **deps, int n);

#ifdef __cplusplus
}
#endif

#endif /* WRAPPER_H */
