/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef ACK_SWAP_COMPONENT_H
#define ACK_SWAP_COMPONENT_H

#include <libpandora/global.h>

#include <libpandora/component.h>
#include <pandora_components/tcppacket.h>

/** Ack swapping component class.
    This component is used to pass TCP acknowledgement packets to the other side
    of a specific connection. The goal is to permit early flushing of packets
    when these are being reordered. If the acknowledgement is empty (size = 0)
    its source and destination are simply swapped, else it uses the 
    \Ref{TCPPacket}
    copy constructor to build an empty packet with the same attributes and 
    then swaps source and destination fields.
    This component should be used with caution since it can generate a lot of
    useless packets, hence slowing down significantly the processing stage.
    @see TCPReorderComponent
 */
class AckSwapComponent : public Component {
private:
  bool create;
public:

  component_init(AckSwapComponent, 1);
  AckSwapComponent(void) : create(false) { 
    registerOption("create", &create); 
  }
  virtual ~AckSwapComponent(void) { }

  virtual bool add(Packet *p);
};

#endif /* ACK_SWAP_COMPONENT_H */
