/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include <iostream>
#include <iomanip>
#include "aggregatecomponent.h"
#include <pandora_components/rpctranspacket.h>
#include <pandora_components/ippacket.h>
#include <libpandora/util.h>

component_export(AggregateComponent, RPCTransPacket,);

bool AggregateComponent::add(Packet *p) 
{
  RPCTransPacket *rtp = static_cast<RPCTransPacket *>(p);

  if (rtp->type != RPCTransPacket::match) {
    ++missed;
    return false;
  }

  locatePacket(IPPacket, ipp, rtp);
  pandora_assert(ipp != NULL);

  if (!count) start = rtp->timeStamp.tv_sec;
  end = rtp->timeStamp.tv_sec;
  if ((end - start) >= interval) display();

  server = ipp->dst.s_addr;
  if (!smap.includesKey(server)) {
    smap.atPut(server, new ServerStat());
  }

  ServerStat *sstat = smap.at(server);

  ++count;		++sstat->count;
  rtt += rtp->rtt;	sstat->rtt += rtp->rtt;

  cleanPacket(rtp);

  return false;
}

void AggregateComponent::display(void) 
{
  if (count > 0) {
    cout << start
	 <<": " << setw(9) << setprecision(6) 
	 << ((float)rtt/(float)count) << '\t'
	 << count << '\t';
      
    Association<u_int32_t, ServerStat*> assoc;
    elementsDo(smap, assoc) {
      ServerStat *sstat = assoc.value;
      if (sstat->count > 0) {
	cout << '(' << intoa(assoc.key) << ' '
	     << ((float)sstat->rtt/(float)sstat->count) << ") ";
      }
      sstat->rtt = sstat->count = 0;
    }
      
    cout << endl;
  }
  rtt = count = missed = 0;
  start = end;
}

void AggregateComponent::cleanup(void) 
{
  if (count > 0) display();
  server = 0;
}
