/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>
#include <libpandora/stackdesc.h>

#include "batchinputcomponent.h"

component_export(BatchInputComponent, Packet, Packet);

BatchInputComponent::BatchInputComponent(void) 
  : doStop(false), factor(1), wait(1000)
{ 
  registerOption("factor", &factor);
  registerOption("wait", &wait);
}

int BatchInputComponent::init(void)   
{ 
  if (factor < 0) return ERROR_FILENO;
  if (wait < 0) return ERROR_FILENO;
  
  olist.setFactor(factor);
  olist.setTimeout(wait);

  doStop = false; 
  return THREADED_FILENO; 
}

bool BatchInputComponent::add(Packet *pkt) 
{
  if (doStop) 	return_clean(pkt);
  compStack->usePacketType(pkt);
  olist.put(pkt);
  return false;
}

bool BatchInputComponent::process(void) 
{
  //pandora_debug("[pipe] waiting for packet");
  int n = olist.get(tab, factor);

  pandora_assert(n <= factor);
  for (int i = 0; i < n; ++i) {
    if (tab[i] == NULL) return true;
    push(tab[i]);
  }

  return false;
}

void BatchInputComponent::finish(void) 
{
  doStop = true;
  //pandora_debug("[flushing " << olist.size() << " queued packets]");
  olist.flush();
  empty();
}

void BatchInputComponent::halt(void)
{
  doStop = true;
  olist.flush();
  olist.put(NULL);
}

void BatchInputComponent::empty(void)
{
  while (isBusy()) {
    Packet *tmp = olist.get();
    cleanPacket(tmp);
  }
}

void BatchInputComponent::setup(void)
{
  tab = new Packet* [factor];
}

void BatchInputComponent::cleanup(void)
{
  __DELETE_ARRAY(tab);
}

