/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef CACHE_EVAL_PACKET_H
#define CACHE_EVAL_PACKET_H

#include <libpandora/global.h>

#include <libpandora/packet.h>

class CacheTransPacket;
class ICPTransPacket;



class CacheEvalPacket : public Packet {
public:
  u_long	rtt;
  long 		rtt_saved;
  long 		lat;
  long 		lat_saved;
  u_long	bytes;
  long 		bytes_saved;
  u_long	bytes_coop;
  long 		stale;
  long 		docs;
  long 		docs_hit;
  long 		docs_miss;
  long 		docs_sibling;

private:

public:
  packet_init(CacheEvalPacket, 1);

  CacheEvalPacket(int);
  CacheEvalPacket(CacheTransPacket *);
  CacheEvalPacket(ICPTransPacket *);
  CacheEvalPacket(const CacheEvalPacket &x);
  CacheEvalPacket &operator=(const CacheEvalPacket &x) ;
  virtual ~CacheEvalPacket(void) {}

  void reset(void);
  void add(const CacheEvalPacket &x);
  void sub(const CacheEvalPacket &x);

  virtual void print(ostream *f) ;

  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);

};

#endif /* CACHE_EVAL_PACKET_H */
