/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include "cacheevalscancomponent.h"
#include <pandora_components/icptranspacket.h>
#include <pandora_components/cachetranspacket.h>

component_export(CacheEvalScanComponent, ICPTransPacket+|CacheTransPacket+, CacheEvalPacket);

exportHandler(CacheEvalScanComponent, CacheTransPacket);
exportHandler(CacheEvalScanComponent, ICPTransPacket);

CacheEvalScanComponent::CacheEvalScanComponent(void) 
{
  registerHandler(CacheEvalScanComponent, CacheTransPacket);
  registerHandler(CacheEvalScanComponent, ICPTransPacket);
}

bool CacheEvalScanComponent::add(CacheTransPacket *ctp) 
{
  push(new CacheEvalPacket(ctp));
  return false;
}

bool CacheEvalScanComponent::add(ICPTransPacket *itp) 
{
  if (itp->type != ICPTransPacket::match) return_clean(itp);
  //if (itp->length > 1000) return_clean(itp);
  push(new CacheEvalPacket(itp));
  return false;
}
