/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef CACHE_TRANS_PACKET_H
#define CACHE_TRANS_PACKET_H

#include <libpandora/global.h>

extern "C" {
#include <netinet/in.h>
#include <netinet/in_systm.h>
}

#include <libpandora/packet.h>
#include <libpandora/serialize.h>

class HTTPTransPacket;


class CacheTransPacket : public Packet {
public:
  enum cachet_t { undefined = -1, miss, miss_sibling, hit_ok, hit_sibling, 
		  hit_bad, avoided, alone, alone_sibling };

public:
  cachet_t	type;
  in_addr 	proxy;
  u_short 	p_sport;
  u_short 	p_dport;
  int 		rtt_saved;
  int 		lat_saved;
  int 		bytes_saved;
  int 		bytes_sibling;
  time_t 	p_ims;
  time_t 	p_ius;
  time_t 	p_lm;
  time_t 	p_expires;

public:
  packet_init(CacheTransPacket, 1);

  CacheTransPacket(HTTPTransPacket *, HTTPTransPacket *);
  CacheTransPacket(HTTPTransPacket *);
  CacheTransPacket(const CacheTransPacket& x);
  CacheTransPacket& operator= (const CacheTransPacket& x);
  virtual ~CacheTransPacket(void) { }

  virtual void print(ostream *) ;

  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);

  inline bool isHit(void) const;

  bool sibling_update(HTTPTransPacket *ctp);
};

bool CacheTransPacket::isHit(void) const
{
  return (type == hit_ok
	  || type == hit_bad
	  || type == hit_sibling);
}

serialEnum(CacheTransPacket::cachet_t);

#endif /* CACHE_TRANS_PACKET_H */
