/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef CCTRL_H
#define CCTRL_H

#include <libpandora/global.h>

#include <iostream>
#include <libpandora/text.h>
#include <libpandora/util.h>
#include <libpandora/error.h>

struct cctrl_t {
public:
  char no_cache, no_store, no_transform, only_if_cached;
  char _public, _private;
  char must_revalidate, proxy_revalidate;
  int max_age, s_max_age, max_stale, min_fresh;

public:
  cctrl_t() : no_cache(0), no_store(0), no_transform(0), only_if_cached(0),
    _public(0), _private(0),
    must_revalidate(0), proxy_revalidate(0),
    max_age(-1), s_max_age(-1), max_stale(-1), min_fresh(-1) {}
  
  cctrl_t(const cctrl_t &x) : no_cache(x.no_cache), no_store(x.no_store), 
      no_transform(x.no_transform), only_if_cached(x.only_if_cached),
      _public(x._public), _private(x._private),
      must_revalidate(x.must_revalidate), proxy_revalidate(x.proxy_revalidate),
      max_age(x.max_age), s_max_age(x.s_max_age), 
      max_stale(x.max_stale), min_fresh(x.min_fresh) {}
  
  cctrl_t operator=(const cctrl_t &x) {
    no_cache = x.no_cache; no_store = x.no_store; 
    no_transform = x.no_transform; only_if_cached = x.only_if_cached;
    _public = x._public; _private = x._private;
    must_revalidate = x.must_revalidate; 
    proxy_revalidate = x.proxy_revalidate;
    max_age = x.max_age; s_max_age = x.s_max_age; 
    max_stale = x.max_stale; min_fresh = x.min_fresh;
    return *this;
  }
  
  ~cctrl_t() {}

  void parse(const char *cstr);
  void print(void);

private:
  inline const char *next_field(const char *cstr);
  void assign(int &lv, const char *cstr);
  void parse_1(const char *cstr) ;
};

const char *cctrl_t::next_field(const char *cstr) 
{
  char *tmp = strchr(cstr, ',');
  return (tmp != NULL ? skip_ws(tmp+1) : NULL);
}

struct etag_t {
public:
  bool weak;
  text tag;

  etag_t() : weak(false) {}
  etag_t(const etag_t &x) : weak(x.weak), tag(x.tag) {}
  etag_t operator=(const etag_t &x) {
    weak = x.weak; tag = x.tag;
    return *this;
  }
  ~etag_t() {}

  void parse(const char *str) ;
  void print(void);
};

#endif /* CCTRL_H */
