/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#include <libpandora/global.h>

#include <limits.h>
#include "consolidatercomponent.h" 
#include <pandora_components/valuepacket.h> 
#include <libpandora/common_options.h>

component_export(ConsolidaterComponent, IntValuePacket+, IntValuePacket);

ConsolidaterComponent::ConsolidaterComponent(void)
  : last(0), start(0), step(1), absolute(false), timeavg(false), func(NULL)
{ 
  registerOption("step",     &step); 
  registerOption("absolute", &absolute);  
  registerOption("timeavg",  &timeavg);  
  registerComplexOption(symbol_option, "func", &func);
  ts.tv_usec = 0;
}

bool ConsolidaterComponent::add(Packet *pkt) 
{
  if (func == NULL) return_clean_fini(pkt);
  locatePacket0(IntValuePacket, vp, pkt);
  if (vp == NULL) return_clean(pkt);

  update(vp);

  cleanPacket(pkt);
  return false;
} 

void ConsolidaterComponent::update(IntValuePacket *vp)
{
  pandora_assert(func != NULL);
  time_t t = (vp->timeStamp).tv_sec;

  if (start == 0) {
    start = t;
    (void)(*func)(stat_init, start, storage);
  }

  while ((start + step) <= t) dispatch();

  int v = (absolute ? vp->val - last : vp->val);
  (void)(*func)(stat_update, v, storage);
  last = vp->val;
}

void ConsolidaterComponent::dispatch(void)
{
  pandora_assert(func != NULL);

  int res = 0;
  (void) (*func)(stat_finish, res, storage);
  if (timeavg) res /= step;
  ts.tv_sec = start;

  push(new IntValuePacket(res, ts));
  start += step;
  
  (void)(*func)(stat_init, start, storage);
}

void ConsolidaterComponent::cleanup(void) 
{ 
  if (func != NULL) dispatch();
}
