/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Here is what remains to be done at this time (2002/02/20)                 *
 *  - Interpolate data when inter-input arrival time is not constant         *
 *  - Explicit the actual ways to use the data collected (queries, graphs)   *
 *  - Support floating values                                                *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef CONSOLIDATER_COMPONENT_H
#define CONSOLIDATER_COMPONENT_H

#include <libpandora/global.h>

#include <libpandora/component.h>
#include <libpandora/stat_functions.h>

class Packet;
class IntValuePacket;

class ConsolidaterComponent : public Component { 
private:
  timeval       ts;
  int		last;
  int		start;
  int		storage[stat_storage_size];

  int 		step; 
  bool		absolute;
  bool		timeavg;
  stat_func_t   func;

public:
  component_init(ConsolidaterComponent, 1);
  ConsolidaterComponent(void);
  virtual ~ConsolidaterComponent(void) { }

  virtual bool add(Packet *p); 
  virtual void cleanup(void);

private:
  void dispatch(void);
  void update(IntValuePacket *);
};

#endif /* CONSOLIDATER_COMPONENT_H */

