/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef CONTROL_PACKET_H
#define CONTROL_PACKET_H

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/time.h>
}

#include <libpandora/packet.h>
#include <libpandora/packetdata.h>
#include <libpandora/serialize.h>


class ControlPacket : public Packet {
public:
  enum controlt_t { undef = -1, reply,
		    start, stop, suspend, resume, clean, quit,
		    set_stack, get_stack, get_stack_name,
		    list_defined, list_running, 
		    set_lib, get_lib, list_libs,
		    set_binding, get_binding, list_symbols,
		    comp_query, get_option, get_option_def, 
		    set_option, set_option_live, list_options,
		    comp_alive, packet_alive,
  		    add_res, del_res, set_res_pri,
		    list_res, update_res };

private:
  controlt_t 	opcode;
  packetData 	data;

public:
  packet_init(ControlPacket, 1);

public:
  ControlPacket(controlt_t o);
  ControlPacket(const ControlPacket& x);
  ControlPacket& operator= (const ControlPacket& x);
  virtual ~ControlPacket(void) { }

  controlt_t getOpcode(void) const { return opcode; }

  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);

  virtual void print(ostream *) ;

  template <class T> void writeParam(const T &arg) { data.writeObject(arg); }
  template <class T> void readParam(T &arg){ data.readObject(arg); }

  void clear(void) { data.clear(); }
};

serialEnum(ControlPacket::controlt_t);

#endif /* CONTROL_PACKET_H */
